/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.ProtocolAwareAssetPathCollector;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;

public class VfsAssetPathCollector
extends ProtocolAwareAssetPathCollector {
    public VfsAssetPathCollector() {
        super("vfs");
    }

    @Override
    public Collection<String> collect(URL url, Pattern filterExpr) {
        HashSet<String> assetPaths = new HashSet<String>();
        try {
            JarEntry entry;
            URLConnection connection = url.openConnection();
            JarInputStream inputStream = (JarInputStream)connection.getInputStream();
            while ((entry = inputStream.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (entry.isDirectory()) continue;
                assetPaths.add("META-INF/resources/webjars/" + entryName);
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Cannot collect the file entries in url: " + String.valueOf(url), x);
        }
        return assetPaths;
    }
}

