/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanBatchPublisherConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanConsumerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanCustomPublisherConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.holder.WanBatchPublisherConfigHolder;
import com.hazelcast.client.impl.protocol.codec.holder.WanConsumerConfigHolder;
import com.hazelcast.client.impl.protocol.codec.holder.WanCustomPublisherConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddWanReplicationConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1774080;
    public static final int RESPONSE_MESSAGE_TYPE = 1774081;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddWanReplicationConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, @Nullable WanConsumerConfigHolder consumerConfig, List<WanCustomPublisherConfigHolder> customPublisherConfigs, List<WanBatchPublisherConfigHolder> batchPublisherConfigs) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddWanReplicationConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1774080);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, consumerConfig, WanConsumerConfigHolderCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, customPublisherConfigs, WanCustomPublisherConfigHolderCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, batchPublisherConfigs, WanBatchPublisherConfigHolderCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.name = StringCodec.decode(iterator);
        request.consumerConfig = CodecUtil.decodeNullable(iterator, WanConsumerConfigHolderCodec::decode);
        request.customPublisherConfigs = ListMultiFrameCodec.decode(iterator, WanCustomPublisherConfigHolderCodec::decode);
        request.batchPublisherConfigs = ListMultiFrameCodec.decode(iterator, WanBatchPublisherConfigHolderCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1774081);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        @Nullable
        public WanConsumerConfigHolder consumerConfig;
        public List<WanCustomPublisherConfigHolder> customPublisherConfigs;
        public List<WanBatchPublisherConfigHolder> batchPublisherConfigs;
    }
}

