/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.nkjp;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.formats.nkjp.NKJPSegmentationDocument;
import opennlp.tools.formats.nkjp.NKJPTextDocument;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class NKJPSentenceSampleStream
implements ObjectStream<SentenceSample> {
    private final NKJPSegmentationDocument segments;
    private final NKJPTextDocument text;
    private Iterator<Map.Entry<String, Map<String, NKJPSegmentationDocument.Pointer>>> segmentIt;

    NKJPSentenceSampleStream(NKJPSegmentationDocument segments, NKJPTextDocument text) {
        this.segments = segments;
        this.text = text;
        this.reset();
    }

    public SentenceSample read() throws IOException {
        StringBuilder sentencesString = new StringBuilder();
        LinkedList<Span> sentenceSpans = new LinkedList<Span>();
        Map<String, String> paragraphs = this.text.getParagraphs();
        while (this.segmentIt.hasNext()) {
            Map.Entry<String, Map<String, NKJPSegmentationDocument.Pointer>> segment = this.segmentIt.next();
            int start = 0;
            int end = 0;
            boolean started = false;
            String lastParagraphId = "";
            String currentParagraph = "";
            for (String s : segment.getValue().keySet()) {
                NKJPSegmentationDocument.Pointer currentPointer = segment.getValue().get(s);
                Span currentSpan = currentPointer.toSpan();
                if (!started) {
                    start = currentSpan.getStart();
                    started = true;
                    lastParagraphId = currentPointer.id;
                    currentParagraph = paragraphs.get(currentPointer.id);
                }
                if (!lastParagraphId.equals(currentPointer.id)) {
                    int new_start = sentencesString.length();
                    sentencesString.append(currentParagraph.substring(start, end));
                    int new_end = sentencesString.length();
                    sentenceSpans.add(new Span(new_start, new_end));
                    sentencesString.append(' ');
                    start = currentSpan.getStart();
                    end = currentSpan.getEnd();
                    lastParagraphId = currentPointer.id;
                    currentParagraph = paragraphs.get(currentPointer.id);
                    continue;
                }
                end = currentSpan.getEnd();
            }
            int new_start = sentencesString.length();
            sentencesString.append(currentParagraph.substring(start, end));
            int new_end = sentencesString.length();
            sentenceSpans.add(new Span(new_start, new_end));
            sentencesString.append(' ');
        }
        if (sentenceSpans.isEmpty()) {
            return null;
        }
        return new SentenceSample((CharSequence)sentencesString.toString(), sentenceSpans.toArray(new Span[0]));
    }

    public void reset() {
        this.segmentIt = this.segments.getSegments().entrySet().iterator();
    }
}

