/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.Archiver;
import org.apache.hadoop.ozone.container.checksum.ContainerChecksumTreeManager;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;

public class TarContainerPacker
implements ContainerPacker<KeyValueContainerData> {
    static final String CHUNKS_DIR_NAME = "chunks";
    static final String DB_DIR_NAME = "db";
    static final String CONTAINER_FILE_NAME = "container.yaml";
    private final CopyContainerCompression compression;
    private final ConfigurationSource conf = new OzoneConfiguration();

    public TarContainerPacker(CopyContainerCompression compression) {
        this.compression = compression;
    }

    @Override
    public byte[] unpackContainerData(Container<KeyValueContainerData> container, InputStream input, Path tmpDir, Path destContainerDir) throws IOException {
        KeyValueContainerData containerData = container.getContainerData();
        long containerId = containerData.getContainerID();
        Path containerUntarDir = tmpDir.resolve(String.valueOf(containerId));
        if (containerUntarDir.toFile().exists()) {
            FileUtils.deleteDirectory((File)containerUntarDir.toFile());
        }
        Path dbRoot = TarContainerPacker.getDbPath(containerUntarDir, containerData);
        Path chunksRoot = TarContainerPacker.getChunkPath(containerUntarDir);
        Path tempContainerMetadataPath = this.getTempContainerMetadataPath(containerUntarDir, containerData);
        byte[] descriptorFileContent = this.innerUnpack(input, dbRoot, chunksRoot, tempContainerMetadataPath);
        if (!Files.exists(destContainerDir, new LinkOption[0])) {
            Files.createDirectories(destContainerDir, new FileAttribute[0]);
        }
        if (FileUtils.isEmptyDirectory((File)destContainerDir.toFile())) {
            if (descriptorFileContent != null) {
                KeyValueContainerData untarContainerData = (KeyValueContainerData)ContainerDataYaml.readContainer(descriptorFileContent);
                ContainerUtils.verifyContainerFileChecksum(untarContainerData, this.conf);
            }
        } else {
            String errorMessage = "Container " + containerId + " unpack failed because ContainerFile " + destContainerDir.toAbsolutePath() + " already exists";
            throw new StorageContainerException(errorMessage, ContainerProtos.Result.CONTAINER_ALREADY_EXISTS);
        }
        this.persistCustomContainerState(container, descriptorFileContent, ContainerProtos.ContainerDataProto.State.RECOVERING, tempContainerMetadataPath);
        Files.move(containerUntarDir, destContainerDir, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        return descriptorFileContent;
    }

    @Override
    public void pack(Container<KeyValueContainerData> container, OutputStream output) throws IOException {
        KeyValueContainerData containerData = container.getContainerData();
        try (ArchiveOutputStream archiveOutput = Archiver.tar((OutputStream)this.compress(output));){
            Archiver.includeFile((File)container.getContainerFile(), (String)CONTAINER_FILE_NAME, (ArchiveOutputStream)archiveOutput);
            File containerChecksumFile = ContainerChecksumTreeManager.getContainerChecksumFile(containerData);
            if (containerChecksumFile.exists()) {
                Archiver.includeFile((File)containerChecksumFile, (String)containerChecksumFile.getName(), (ArchiveOutputStream)archiveOutput);
            }
            Archiver.includePath((Path)TarContainerPacker.getDbPath(containerData), (String)DB_DIR_NAME, (ArchiveOutputStream)archiveOutput);
            Archiver.includePath((Path)Paths.get(containerData.getChunksPath(), new String[0]), (String)CHUNKS_DIR_NAME, (ArchiveOutputStream)archiveOutput);
        }
    }

    @Override
    public byte[] unpackContainerDescriptor(InputStream input) throws IOException {
        try (ArchiveInputStream archiveInput = Archiver.untar((InputStream)this.decompress(input));){
            ArchiveEntry entry = archiveInput.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (CONTAINER_FILE_NAME.equals(name)) {
                    byte[] byArray = Archiver.readEntry((InputStream)archiveInput, (long)entry.getSize());
                    return byArray;
                }
                entry = archiveInput.getNextEntry();
            }
        }
        throw new IOException("Container descriptor is missing from the container archive.");
    }

    public static Path getDbPath(KeyValueContainerData containerData) {
        if (containerData.hasSchema("3")) {
            return DatanodeStoreSchemaThreeImpl.getDumpDir(new File(containerData.getMetadataPath())).toPath();
        }
        return containerData.getDbFile().toPath();
    }

    public static Path getDbPath(Path baseDir, KeyValueContainerData containerData) {
        if (baseDir.toAbsolutePath().toString().equals(containerData.getContainerPath())) {
            return TarContainerPacker.getDbPath(containerData);
        }
        Path containerPath = Paths.get(containerData.getContainerPath(), new String[0]);
        Path dbPath = Paths.get(containerData.getDbFile().getPath(), new String[0]);
        Path relativePath = containerPath.relativize(dbPath);
        if (containerData.hasSchema("3")) {
            Path metadataDir = KeyValueContainerLocationUtil.getContainerMetaDataPath(baseDir.toString()).toPath();
            return DatanodeStoreSchemaThreeImpl.getDumpDir(metadataDir.toFile()).toPath();
        }
        return baseDir.resolve(relativePath);
    }

    public static Path getChunkPath(Path baseDir) {
        return KeyValueContainerLocationUtil.getChunksLocationPath(baseDir.toString()).toPath();
    }

    private Path getContainerMetadataPath(ContainerData containerData) {
        return Paths.get(containerData.getMetadataPath(), new String[0]);
    }

    private Path getTempContainerMetadataPath(Path containerUntarDir, ContainerData containerData) {
        Path containerMetadataPath = this.getContainerMetadataPath(containerData);
        return Paths.get(containerUntarDir.toString(), containerMetadataPath.getName(containerMetadataPath.getNameCount() - 1).toString());
    }

    InputStream decompress(InputStream input) throws IOException {
        return this.compression.wrap(input);
    }

    OutputStream compress(OutputStream output) throws IOException {
        return this.compression.wrap(output);
    }

    private byte[] innerUnpack(InputStream input, Path dbRoot, Path chunksRoot, Path metadataRoot) throws IOException {
        byte[] descriptorFileContent = null;
        try (ArchiveInputStream archiveInput = Archiver.untar((InputStream)this.decompress(input));){
            ArchiveEntry entry = archiveInput.getNextEntry();
            while (entry != null) {
                Path destinationPath;
                String name = entry.getName();
                long size = entry.getSize();
                if (name.startsWith("db/")) {
                    destinationPath = dbRoot.resolve(name.substring(DB_DIR_NAME.length() + 1));
                    Archiver.extractEntry((ArchiveEntry)entry, (InputStream)archiveInput, (long)size, (Path)dbRoot, (Path)destinationPath);
                } else if (name.startsWith("chunks/")) {
                    destinationPath = chunksRoot.resolve(name.substring(CHUNKS_DIR_NAME.length() + 1));
                    Archiver.extractEntry((ArchiveEntry)entry, (InputStream)archiveInput, (long)size, (Path)chunksRoot, (Path)destinationPath);
                } else if (name.endsWith(".tree")) {
                    destinationPath = metadataRoot.resolve(name);
                    Archiver.extractEntry((ArchiveEntry)entry, (InputStream)archiveInput, (long)size, (Path)metadataRoot, (Path)destinationPath);
                } else if (CONTAINER_FILE_NAME.equals(name)) {
                    descriptorFileContent = Archiver.readEntry((InputStream)archiveInput, (long)size);
                } else {
                    throw new IllegalArgumentException("Unknown entry in the tar file: " + name);
                }
                entry = archiveInput.getNextEntry();
            }
            byte[] byArray = descriptorFileContent;
            return byArray;
        }
    }
}

