/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateIndexIncludeStep;
import org.jooq.CreateIndexStep;
import org.jooq.Field;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;

final class CreateIndexImpl
extends AbstractQuery
implements CreateIndexStep,
CreateIndexIncludeStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_INDEX};
    private static final EnumSet<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = EnumSet.of(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final EnumSet<SQLDialect> SUPPORT_UNNAMED_INDEX = EnumSet.of(SQLDialect.POSTGRES);
    private final Index index;
    private final boolean unique;
    private final boolean ifNotExists;
    private Table<?> table;
    private Field<?>[] fields;
    private Field<?>[] include;
    private SortField<?>[] sortFields;
    private Condition where;

    CreateIndexImpl(Configuration configuration, Index index, boolean unique, boolean ifNotExists) {
        super(configuration);
        this.index = index;
        this.unique = unique;
        this.ifNotExists = ifNotExists;
        if (index != null) {
            this.table = index.getTable();
            this.sortFields = index.getFields().toArray(Tools.EMPTY_SORTFIELD);
            this.where = index.getWhere();
        }
    }

    @Override
    public final CreateIndexImpl on(Table<?> t, OrderField<?> ... f) {
        this.table = t;
        this.sortFields = Tools.sortFields(f);
        return this;
    }

    @Override
    public final CreateIndexImpl on(Table<?> t, Collection<? extends OrderField<?>> fields) {
        return this.on((Table)t, (OrderField[])fields.toArray(Tools.EMPTY_ORDERFIELD));
    }

    @Override
    public final CreateIndexImpl on(Name tableName, Name ... fieldNames) {
        return this.on((Table)DSL.table(tableName), Tools.fieldsByName(fieldNames));
    }

    @Override
    public final CreateIndexImpl on(Name tableName, Collection<? extends Name> fieldNames) {
        return this.on(tableName, fieldNames.toArray(Tools.EMPTY_NAME));
    }

    @Override
    public final CreateIndexImpl on(String tableName, String ... fieldNames) {
        return this.on((Table)DSL.table(DSL.name(tableName)), Tools.fieldsByName(fieldNames));
    }

    @Override
    public final CreateIndexImpl on(String tableName, Collection<? extends String> fieldNames) {
        return this.on(tableName, fieldNames.toArray(Tools.EMPTY_STRING));
    }

    @Override
    public final CreateIndexImpl include(Field<?> ... f) {
        this.include = f;
        return this;
    }

    @Override
    public final CreateIndexImpl include(Name ... f) {
        return this.include((Field[])Tools.fieldsByName(f));
    }

    @Override
    public final CreateIndexImpl include(String ... f) {
        return this.include((Field[])Tools.fieldsByName(f));
    }

    @Override
    public final CreateIndexImpl include(Collection<? extends Field<?>> fields) {
        return this.include((Field[])fields.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final CreateIndexImpl where(Condition condition) {
        this.where = condition;
        return this;
    }

    @Override
    public final CreateIndexImpl where(Condition ... conditions) {
        this.where = DSL.and(conditions);
        return this;
    }

    @Override
    public final CreateIndexImpl where(Collection<? extends Condition> conditions) {
        this.where = DSL.and(conditions);
        return this;
    }

    @Override
    public final CreateIndexImpl where(Field<Boolean> field) {
        return this.where(DSL.condition(field));
    }

    @Override
    public final CreateIndexImpl where(SQL sql) {
        return this.where(DSL.condition(sql));
    }

    @Override
    public final CreateIndexImpl where(String sql) {
        return this.where(DSL.condition(sql));
    }

    @Override
    public final CreateIndexImpl where(String sql, Object ... bindings) {
        return this.where(DSL.condition(sql, bindings));
    }

    @Override
    public final CreateIndexImpl where(String sql, QueryPart ... parts) {
        return this.where(DSL.condition(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_INDEX);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_INDEX);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE);
        if (this.unique) {
            ctx.sql(' ').visit(Keywords.K_UNIQUE);
        }
        ctx.sql(' ').visit(Keywords.K_INDEX).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        if (this.index != null) {
            ctx.visit(this.index).sql(' ');
        } else if (!SUPPORT_UNNAMED_INDEX.contains((Object)ctx.family())) {
            ctx.visit(this.generatedName()).sql(' ');
        }
        boolean supportsInclude = false;
        boolean supportsFieldsBeforeTable = false;
        QueryPartList list = new QueryPartList();
        if (this.fields != null) {
            list.addAll((Collection<OrderField<?>>)Arrays.asList(this.fields));
        } else {
            list.addAll((Collection<OrderField<?>>)Arrays.asList(this.sortFields));
        }
        if (!supportsInclude && this.include != null) {
            list.addAll((Collection<OrderField<?>>)Arrays.asList(this.include));
        }
        ctx.visit(Keywords.K_ON).sql(' ').visit(this.table);
        ctx.sql('(').qualify(false).visit(list).qualify(true).sql(')');
        if (supportsInclude && this.include != null) {
            ctx.formatSeparator().visit(Keywords.K_INCLUDE).sql(" (").qualify(false).visit(new QueryPartList((QueryPart[])this.include)).qualify(true).sql(')');
        }
        if (this.where != null && ctx.configuration().data("org.jooq.meta.extensions.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(Keywords.K_WHERE).sql(' ').qualify(false).visit(this.where).qualify(true);
        }
    }

    private final Name generatedName() {
        Name t = this.table.getQualifiedName();
        StringBuilder sb = new StringBuilder(this.table.getName());
        for (SortField<?> f : this.sortFields) {
            sb.append('_').append(f.getName());
        }
        sb.append("_idx");
        if (t.qualified()) {
            return t.qualifier().append(sb.toString());
        }
        return DSL.name(sb.toString());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

