/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.persistence;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.hadoop.ozone.recon.persistence.DataSourceConfiguration;
import org.apache.ozone.recon.schema.SqlDbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDataSourceProvider
implements Provider<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DerbyDataSourceProvider.class);
    private DataSourceConfiguration configuration;

    @Inject
    DerbyDataSourceProvider(DataSourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public DataSource get() {
        String jdbcUrl = this.configuration.getJdbcUrl();
        try {
            SqlDbUtils.createNewDerbyDatabase((String)jdbcUrl, (String)"RECON");
        }
        catch (Exception e) {
            LOG.error("Error creating Recon Derby DB.", (Throwable)e);
        }
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        dataSource.setDatabaseName(jdbcUrl.split(":")[2]);
        dataSource.setUser("RECON");
        return dataSource;
    }
}

