/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.ozone.recon.api.types.KeyPrefixContainer;

public final class KeyPrefixContainerCodec
implements Codec<KeyPrefixContainer> {
    private static final Codec<KeyPrefixContainer> INSTANCE = new KeyPrefixContainerCodec();
    private static final String KEY_DELIMITER = "_";
    private static final byte[] KEY_DELIMITER_BYTES = "_".getBytes(StandardCharsets.UTF_8);
    private static final ByteBuffer KEY_DELIMITER_BUFFER = ByteBuffer.wrap(KEY_DELIMITER_BYTES).asReadOnlyBuffer();
    public static final int LONG_SERIALIZED_SIZE = KEY_DELIMITER_BYTES.length + 8;

    public static Codec<KeyPrefixContainer> get() {
        return INSTANCE;
    }

    private KeyPrefixContainerCodec() {
    }

    public Class<KeyPrefixContainer> getTypeClass() {
        return KeyPrefixContainer.class;
    }

    public boolean supportCodecBuffer() {
        return true;
    }

    public CodecBuffer toCodecBuffer(@Nonnull KeyPrefixContainer object, CodecBuffer.Allocator allocator) {
        Preconditions.checkNotNull((Object)object, (Object)"Null object can't be converted to CodecBuffer.");
        byte[] keyPrefixBytes = object.getKeyPrefix().getBytes(StandardCharsets.UTF_8);
        int totalSize = keyPrefixBytes.length;
        if (object.getKeyVersion() != -1L) {
            totalSize += LONG_SERIALIZED_SIZE;
            if (object.getContainerId() != -1L) {
                totalSize += LONG_SERIALIZED_SIZE;
            }
        }
        CodecBuffer buffer = (CodecBuffer)allocator.apply(totalSize);
        buffer.put(ByteBuffer.wrap(keyPrefixBytes));
        if (object.getKeyVersion() != -1L) {
            buffer.put(KEY_DELIMITER_BUFFER.duplicate());
            buffer.putLong(object.getKeyVersion());
            if (object.getContainerId() != -1L) {
                buffer.put(KEY_DELIMITER_BUFFER.duplicate());
                buffer.putLong(object.getContainerId());
            }
        }
        return buffer;
    }

    public KeyPrefixContainer fromCodecBuffer(@Nonnull CodecBuffer buffer) throws CodecException {
        ByteBuffer byteBuffer = buffer.asReadOnlyByteBuffer();
        int totalLength = byteBuffer.remaining();
        if (totalLength == 0) {
            throw new CodecException("Empty buffer");
        }
        byte[] data = new byte[totalLength];
        byteBuffer.get(data);
        int lastDelimiter = this.findLastDelimiter(data);
        if (lastDelimiter == -1) {
            return KeyPrefixContainer.get(new String(data, StandardCharsets.UTF_8));
        }
        int secondLastDelimiter = this.findLastDelimiter(data, lastDelimiter - 1);
        if (secondLastDelimiter == -1) {
            String keyPrefix = new String(data, 0, lastDelimiter, StandardCharsets.UTF_8);
            long version = Longs.fromByteArray((byte[])ArrayUtils.subarray((byte[])data, (int)(lastDelimiter + 1), (int)(lastDelimiter + 1 + 8)));
            return KeyPrefixContainer.get(keyPrefix, version);
        }
        String keyPrefix = new String(data, 0, secondLastDelimiter, StandardCharsets.UTF_8);
        long version = Longs.fromByteArray((byte[])ArrayUtils.subarray((byte[])data, (int)(secondLastDelimiter + 1), (int)(secondLastDelimiter + 1 + 8)));
        long containerId = Longs.fromByteArray((byte[])ArrayUtils.subarray((byte[])data, (int)(lastDelimiter + 1), (int)(lastDelimiter + 1 + 8)));
        return KeyPrefixContainer.get(keyPrefix, version, containerId);
    }

    private int findLastDelimiter(byte[] data) {
        return this.findLastDelimiter(data, data.length - 1);
    }

    private int findLastDelimiter(byte[] data, int endPos) {
        for (int i = endPos - 8; i >= 0; --i) {
            if (data[i] != 95) continue;
            return i;
        }
        return -1;
    }

    public byte[] toPersistedFormat(KeyPrefixContainer keyPrefixContainer) {
        Preconditions.checkNotNull((Object)keyPrefixContainer, (Object)"Null object can't be converted to byte array.");
        byte[] keyPrefixBytes = keyPrefixContainer.getKeyPrefix().getBytes(StandardCharsets.UTF_8);
        if (keyPrefixContainer.getKeyVersion() != -1L) {
            keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])KEY_DELIMITER_BYTES);
            keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])Longs.toByteArray((long)keyPrefixContainer.getKeyVersion()));
            if (keyPrefixContainer.getContainerId() != -1L) {
                keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])KEY_DELIMITER_BYTES);
                keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])Longs.toByteArray((long)keyPrefixContainer.getContainerId()));
            }
        }
        return keyPrefixBytes;
    }

    public KeyPrefixContainer fromPersistedFormat(byte[] rawData) {
        byte[] keyBytes = ArrayUtils.subarray((byte[])rawData, (int)0, (int)(rawData.length - 16 - 2));
        String keyPrefix = new String(keyBytes, StandardCharsets.UTF_8);
        byte[] versionBytes = ArrayUtils.subarray((byte[])rawData, (int)(rawData.length - 16 - 1), (int)(rawData.length - 8 - 1));
        long version = ByteBuffer.wrap(versionBytes).getLong();
        long containerIdFromDB = ByteBuffer.wrap(ArrayUtils.subarray((byte[])rawData, (int)(rawData.length - 8), (int)rawData.length)).getLong();
        return KeyPrefixContainer.get(keyPrefix, version, containerIdFromDB);
    }

    public KeyPrefixContainer copyObject(KeyPrefixContainer object) {
        return object;
    }
}

