/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.lib.wsrs;

import java.util.Arrays;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;
import org.apache.ozone.lib.wsrs.Param;

@InterfaceAudience.Private
public abstract class EnumParam<E extends Enum<E>>
extends Param<E> {
    private Class<E> klass;

    public EnumParam(String name, Class<E> e, E defaultValue) {
        super(name, defaultValue);
        this.klass = e;
    }

    @Override
    protected E parse(String str) throws Exception {
        return Enum.valueOf(this.klass, StringUtils.toUpperCase((String)str));
    }

    @Override
    protected String getDomain() {
        return StringUtils.join((CharSequence)",", Arrays.asList((Enum[])this.klass.getEnumConstants()));
    }
}

