/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.managed.ManagedCompactRangeOptions;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.util.Time;
import org.rocksdb.CompactRangeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionService.class);
    private static final int COMPACTOR_THREAD_POOL_SIZE = 1;
    private final OzoneManager ozoneManager;
    private final OMMetadataManager omMetadataManager;
    private final AtomicLong numCompactions;
    private final AtomicBoolean suspended;
    private final List<String> compactableTables;

    public CompactionService(OzoneManager ozoneManager, TimeUnit unit, long interval, long timeout, List<String> tables) {
        super("CompactionService", interval, unit, 1, timeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.omMetadataManager = this.ozoneManager.getMetadataManager();
        this.numCompactions = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
        this.compactableTables = this.validateTables(tables);
    }

    private List<String> validateTables(List<String> tables) {
        if (tables == null || tables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> validTables = new ArrayList<String>();
        HashSet allTableNames = new HashSet(this.omMetadataManager.listTableNames());
        for (String table : tables) {
            if (allTableNames.contains(table)) {
                validTables.add(table);
                continue;
            }
            LOG.warn("CompactionService: Table \"{}\" not found in OM metadata. Skipping this table.", (Object)table);
        }
        if (validTables.isEmpty()) {
            LOG.error("CompactionService: No valid compaction tables found. Failing initialization.");
            throw new IllegalArgumentException("CompactionService: None of the provided tables are valid.");
        }
        return Collections.unmodifiableList(validTables);
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    @VisibleForTesting
    public List<String> getCompactableTables() {
        return this.compactableTables;
    }

    @VisibleForTesting
    public long getNumCompactions() {
        return this.numCompactions.get();
    }

    public synchronized BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        for (String tableName : this.compactableTables) {
            queue.add((BackgroundTask)new CompactTask(tableName));
        }
        return queue;
    }

    private boolean shouldRun() {
        return !this.suspended.get();
    }

    protected void compactFully(String tableName) throws IOException {
        long startTime = Time.monotonicNow();
        LOG.info("Compacting column family: {}", (Object)tableName);
        Throwable throwable = null;
        Object var5_5 = null;
        try (ManagedCompactRangeOptions options = new ManagedCompactRangeOptions();){
            options.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
            options.setExclusiveManualCompaction(true);
            RocksDatabase rocksDatabase = ((RDBStore)this.omMetadataManager.getStore()).getDb();
            try {
                RocksDatabase.ColumnFamily columnFamily = rocksDatabase.getColumnFamily(tableName);
                rocksDatabase.compactRange(columnFamily, null, null, options);
                LOG.info("Compaction of column family: {} completed in {} ms", (Object)tableName, (Object)(Time.monotonicNow() - startTime));
            }
            catch (NullPointerException nullPointerException) {
                LOG.error("Unable to trigger compaction for \"{}\". Column family not found ", (Object)tableName);
                throw new IOException("Column family \"" + tableName + "\" not found.");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class CompactTask
    implements BackgroundTask {
        private final String tableName;

        CompactTask(String tableName) {
            this.tableName = tableName;
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            if (!CompactionService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            LOG.debug("Running CompactTask");
            CompactionService.this.compactFully(this.tableName);
            CompactionService.this.numCompactions.incrementAndGet();
            return () -> 1;
        }
    }
}

