/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.ozone.BasicKeyInfo;
import org.apache.hadoop.fs.ozone.FileStatusAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneFSDataStreamOutput;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneFsServerDefaults;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.LeaseKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicOzoneClientAdapterImpl
implements OzoneClientAdapter {
    static final Logger LOG = LoggerFactory.getLogger(BasicOzoneClientAdapterImpl.class);
    public static final String ACTIVE_FS_SNAPSHOT_NAME = ".";
    private OzoneClient ozoneClient;
    private ObjectStore objectStore;
    private OzoneVolume volume;
    private OzoneBucket bucket;
    private ReplicationConfig bucketReplicationConfig;
    private ReplicationConfig clientConfiguredReplicationConfig;
    private boolean securityEnabled;
    private int configuredDnPort;
    private OzoneConfiguration config;
    private long nextReplicationConfigRefreshTime;
    private long bucketRepConfigRefreshPeriodMS;
    private Clock clock = Clock.system(ZoneOffset.UTC);

    public BasicOzoneClientAdapterImpl(String volumeStr, String bucketStr) throws IOException {
        this(new OzoneConfiguration(), volumeStr, bucketStr);
    }

    public BasicOzoneClientAdapterImpl(OzoneConfiguration conf, String volumeStr, String bucketStr) throws IOException {
        this(null, -1, (ConfigurationSource)conf, volumeStr, bucketStr);
    }

    public BasicOzoneClientAdapterImpl(String omHost, int omPort, ConfigurationSource hadoopConf, String volumeStr, String bucketStr) throws IOException {
        SecurityConfig secConfig;
        OzoneConfiguration conf = OzoneConfiguration.of((ConfigurationSource)hadoopConf);
        this.bucketRepConfigRefreshPeriodMS = conf.getLong("ozone.client.bucket.replication.config.refresh.time.ms", 300000L);
        if (omHost == null && OmUtils.isServiceIdsDefined((ConfigurationSource)conf)) {
            throw new IllegalArgumentException("Service ID or host name must not be omitted when ozone.om.service.ids is defined.");
        }
        if (omPort != -1) {
            if (OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omHost)) {
                throw new IllegalArgumentException("Port " + omPort + " specified in URI but host '" + omHost + "' is a logical (HA) OzoneManager and does not use port information.");
            }
        } else {
            omPort = OmUtils.getOmRpcPort((ConfigurationSource)conf);
        }
        if ((secConfig = new SecurityConfig((ConfigurationSource)conf)).isSecurityEnabled()) {
            this.securityEnabled = true;
        }
        this.clientConfiguredReplicationConfig = OzoneClientUtils.getClientConfiguredReplicationConfig((ConfigurationSource)conf);
        this.ozoneClient = OmUtils.isOmHAServiceId((ConfigurationSource)conf, (String)omHost) ? OzoneClientFactory.getRpcClient((String)omHost, (ConfigurationSource)conf) : (StringUtils.isNotEmpty((CharSequence)omHost) && omPort != -1 ? OzoneClientFactory.getRpcClient((String)omHost, (Integer)omPort, (MutableConfigurationSource)conf) : OzoneClientFactory.getRpcClient((ConfigurationSource)conf));
        this.objectStore = this.ozoneClient.getObjectStore();
        try {
            this.volume = this.objectStore.getVolume(volumeStr);
            this.bucket = this.volume.getBucket(bucketStr);
            this.bucketReplicationConfig = this.bucket.getReplicationConfig();
            this.nextReplicationConfigRefreshTime = this.clock.millis() + this.bucketRepConfigRefreshPeriodMS;
            BucketLayout resolvedBucketLayout = OzoneClientUtils.resolveLinkBucketLayout((OzoneBucket)this.bucket, (ObjectStore)this.objectStore, new HashSet());
            OzoneFSUtils.validateBucketLayout((String)this.bucket.getName(), (BucketLayout)resolvedBucketLayout);
        }
        catch (IOException | RuntimeException exception) {
            this.ozoneClient.close();
            throw exception;
        }
        this.configuredDnPort = conf.getInt("hdds.container.ipc.port", 9859);
        this.config = conf;
    }

    @Override
    public short getDefaultReplication() {
        if (this.clientConfiguredReplicationConfig == null) {
            return (short)ReplicationFactor.THREE.getValue();
        }
        return (short)this.clientConfiguredReplicationConfig.getRequiredNodes();
    }

    @Override
    public void close() throws IOException {
        this.ozoneClient.close();
    }

    @Override
    public InputStream readFile(String key) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_READ, 1L);
        try {
            return this.bucket.readFile(key).getInputStream();
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND || ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileNotFoundException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    protected void incrementCounter(Statistic objectsRead, long count) {
    }

    @Override
    public OzoneFSOutputStream createFile(String key, short replication, boolean overWrite, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        try {
            OzoneOutputStream ozoneOutputStream = this.bucket.createFile(key, 0L, OzoneClientUtils.resolveClientSideReplicationConfig((short)replication, (ReplicationConfig)this.clientConfiguredReplicationConfig, (ReplicationConfig)this.getReplicationConfigWithRefreshCheck(), (ConfigurationSource)this.config), overWrite, recursive);
            return new OzoneFSOutputStream(ozoneOutputStream);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileAlreadyExistsException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    private ReplicationConfig getReplicationConfigWithRefreshCheck() throws IOException {
        if (this.clock.millis() > this.nextReplicationConfigRefreshTime) {
            this.bucketReplicationConfig = this.volume.getBucket(this.bucket.getName()).getReplicationConfig();
            this.nextReplicationConfigRefreshTime = this.clock.millis() + this.bucketRepConfigRefreshPeriodMS;
        }
        return this.bucketReplicationConfig;
    }

    @Override
    public OzoneFSDataStreamOutput createStreamFile(String key, short replication, boolean overWrite, boolean recursive) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        try {
            ReplicationConfig replicationConfig = OzoneClientUtils.resolveClientSideReplicationConfig((short)replication, (ReplicationConfig)this.clientConfiguredReplicationConfig, (ReplicationConfig)this.getReplicationConfigWithRefreshCheck(), (ConfigurationSource)this.config);
            OzoneDataStreamOutput out = this.bucket.createStreamFile(key, 0L, replicationConfig, overWrite, recursive);
            return new OzoneFSDataStreamOutput(out.getByteBufStreamOutput());
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS || ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileAlreadyExistsException(ex.getResult().name() + ": " + ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public void renameKey(String key, String newKeyName) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_RENAMED, 1L);
        this.bucket.renameKey(key, newKeyName);
    }

    @Override
    public void rename(String pathStr, String newPath) throws IOException {
        throw new IOException("Please use renameKey instead for o3fs.");
    }

    @Override
    public boolean createDirectory(String keyName) throws IOException {
        LOG.trace("creating dir for key:{}", (Object)keyName);
        this.incrementCounter(Statistic.OBJECTS_CREATED, 1L);
        try {
            this.bucket.createDirectory(keyName);
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS) {
                throw new FileAlreadyExistsException(e.getMessage());
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean deleteObject(String keyName) throws IOException {
        return this.deleteObject(keyName, false);
    }

    @Override
    public boolean deleteObject(String keyName, boolean recursive) throws IOException {
        LOG.trace("issuing delete for key {}", (Object)keyName);
        try {
            this.incrementCounter(Statistic.OBJECTS_DELETED, 1L);
            this.bucket.deleteDirectory(keyName, recursive);
            return true;
        }
        catch (OMException ome) {
            if (OMException.ResultCodes.KEY_NOT_FOUND == ome.getResult()) {
                LOG.warn("delete key failed {}", (Object)ome.getMessage());
                return false;
            }
            LOG.error("delete key failed {}", (Object)ome.getMessage());
            if (OMException.ResultCodes.DIRECTORY_NOT_EMPTY == ome.getResult()) {
                throw new PathIsNotEmptyDirectoryException(ome.getMessage());
            }
            return false;
        }
        catch (IOException ioe) {
            LOG.error("delete key failed {}", (Object)ioe.getMessage());
            return false;
        }
    }

    @Override
    public boolean deleteObjects(List<String> keyNameList) {
        try {
            this.incrementCounter(Statistic.OBJECTS_DELETED, keyNameList.size());
            this.bucket.deleteKeys(keyNameList);
            return true;
        }
        catch (IOException ioe) {
            LOG.error("delete key failed {}", (Object)ioe.getMessage());
            return false;
        }
    }

    @Override
    public FileStatusAdapter getFileStatus(String key, URI uri, Path qualifiedPath, String userName) throws IOException {
        try {
            this.incrementCounter(Statistic.OBJECTS_QUERY, 1L);
            OzoneFileStatus status = this.bucket.getFileStatus(key);
            return this.toFileStatusAdapter(status, userName, uri, qualifiedPath);
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(key + ": No such file or directory!");
            }
            throw e;
        }
    }

    @Override
    public Iterator<BasicKeyInfo> listKeys(String pathKey) throws IOException {
        this.incrementCounter(Statistic.OBJECTS_LIST, 1L);
        return new IteratorAdapter(this.bucket.listKeys(pathKey));
    }

    @Override
    public List<FileStatusAdapter> listStatus(String keyName, boolean recursive, String startKey, long numEntries, URI uri, Path workingDir, String username, boolean lite) throws IOException {
        try {
            this.incrementCounter(Statistic.OBJECTS_LIST, 1L);
            ArrayList<FileStatusAdapter> result = new ArrayList<FileStatusAdapter>();
            if (lite) {
                List statuses = this.bucket.listStatusLight(keyName, recursive, startKey, numEntries);
                for (OzoneFileStatusLight status : statuses) {
                    result.add(this.toFileStatusAdapter(status, username, uri, workingDir));
                }
            } else {
                List statuses = this.bucket.listStatus(keyName, recursive, startKey, numEntries);
                for (OzoneFileStatus status : statuses) {
                    result.add(this.toFileStatusAdapter(status, username, uri, workingDir));
                }
            }
            return result;
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        if (!this.securityEnabled) {
            return null;
        }
        Token token = this.ozoneClient.getObjectStore().getDelegationToken(renewer == null ? null : new Text(renewer));
        token.setKind(OzoneTokenIdentifier.KIND_NAME);
        return token;
    }

    @Override
    public OzoneFsServerDefaults getServerDefaults() throws IOException {
        return this.objectStore.getServerDefaults();
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return this.objectStore.getKeyProvider();
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return this.objectStore.getKeyProviderUri();
    }

    @Override
    public String getCanonicalServiceName() {
        return this.objectStore.getCanonicalServiceName();
    }

    @VisibleForTesting
    void setClock(Clock monotonicClock) {
        this.clock = monotonicClock;
    }

    private FileStatusAdapter toFileStatusAdapter(OzoneFileStatus status, String owner, URI defaultUri, Path workingDir) {
        OmKeyInfo keyInfo = status.getKeyInfo();
        short replication = (short)keyInfo.getReplicationConfig().getRequiredNodes();
        return new FileStatusAdapter(keyInfo.getDataSize(), keyInfo.getReplicatedSize(), new Path("/" + keyInfo.getKeyName()).makeQualified(defaultUri, workingDir), status.isDirectory(), replication, status.getBlockSize(), keyInfo.getModificationTime(), keyInfo.getModificationTime(), status.isDirectory() ? (short)511 : 438, (String)StringUtils.defaultIfEmpty((CharSequence)keyInfo.getOwnerName(), (CharSequence)owner), owner, null, this.getBlockLocations(status), OzoneClientUtils.isKeyEncrypted((OmKeyInfo)keyInfo), OzoneClientUtils.isKeyErasureCode((OmKeyInfo)keyInfo));
    }

    private FileStatusAdapter toFileStatusAdapter(OzoneFileStatusLight status, String owner, URI defaultUri, Path workingDir) {
        BasicOmKeyInfo keyInfo = status.getKeyInfo();
        short replication = (short)keyInfo.getReplicationConfig().getRequiredNodes();
        return new FileStatusAdapter(keyInfo.getDataSize(), keyInfo.getReplicatedSize(), new Path("/" + keyInfo.getKeyName()).makeQualified(defaultUri, workingDir), status.isDirectory(), replication, status.getBlockSize(), keyInfo.getModificationTime(), keyInfo.getModificationTime(), status.isDirectory() ? (short)511 : 438, (String)StringUtils.defaultIfEmpty((CharSequence)keyInfo.getOwnerName(), (CharSequence)owner), owner, null, this.getBlockLocations(null), keyInfo.isEncrypted(), OzoneClientUtils.isKeyErasureCode((BasicOmKeyInfo)keyInfo));
    }

    private BlockLocation[] getBlockLocations(OzoneFileStatus fileStatus) {
        if (fileStatus == null) {
            return new BlockLocation[0];
        }
        OmKeyInfo keyInfo = fileStatus.getKeyInfo();
        if (keyInfo == null || CollectionUtils.isEmpty((Collection)keyInfo.getKeyLocationVersions())) {
            return new BlockLocation[0];
        }
        List omKeyLocationInfoGroups = keyInfo.getKeyLocationVersions();
        if (CollectionUtils.isEmpty((Collection)omKeyLocationInfoGroups)) {
            return new BlockLocation[0];
        }
        OmKeyLocationInfoGroup omKeyLocationInfoGroup = keyInfo.getLatestVersionLocations();
        BlockLocation[] blockLocations = new BlockLocation[omKeyLocationInfoGroup.getBlocksLatestVersionOnly().size()];
        int i = 0;
        long offsetOfBlockInFile = 0L;
        for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoGroup.getBlocksLatestVersionOnly()) {
            ArrayList hostList = new ArrayList();
            ArrayList nameList = new ArrayList();
            omKeyLocationInfo.getPipeline().getNodes().forEach(dn -> {
                hostList.add(dn.getHostName());
                int port = dn.getStandalonePort().getValue();
                if (port == 0) {
                    port = this.configuredDnPort;
                }
                nameList.add(dn.getHostName() + ":" + port);
            });
            String[] hosts = hostList.toArray(new String[0]);
            String[] names = nameList.toArray(new String[0]);
            BlockLocation blockLocation = new BlockLocation(names, hosts, offsetOfBlockInFile, omKeyLocationInfo.getLength());
            offsetOfBlockInFile += omKeyLocationInfo.getLength();
            blockLocations[i++] = blockLocation;
        }
        return blockLocations;
    }

    @Override
    public boolean isFSOptimizedBucket() {
        return this.bucket.getBucketLayout().isFileSystemOptimized();
    }

    @Override
    public FileChecksum getFileChecksum(String keyName, long length) throws IOException {
        OzoneClientConfig.ChecksumCombineMode combineMode = ((OzoneClientConfig)this.config.getObject(OzoneClientConfig.class)).getChecksumCombineMode();
        if (combineMode == null) {
            return null;
        }
        return OzoneClientUtils.getFileChecksumWithCombineMode((OzoneVolume)this.volume, (OzoneBucket)this.bucket, (String)keyName, (long)length, (OzoneClientConfig.ChecksumCombineMode)combineMode, (ClientProtocol)this.ozoneClient.getObjectStore().getClientProxy());
    }

    @Override
    public String createSnapshot(String pathStr, String snapshotName) throws IOException {
        return this.objectStore.createSnapshot(this.volume.getName(), this.bucket.getName(), snapshotName);
    }

    @Override
    public void renameSnapshot(String pathStr, String snapshotOldName, String snapshotNewName) throws IOException {
        this.objectStore.renameSnapshot(this.volume.getName(), this.bucket.getName(), snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(String pathStr, String snapshotName) throws IOException {
        this.objectStore.deleteSnapshot(this.volume.getName(), this.bucket.getName(), snapshotName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException, InterruptedException {
        boolean takeTemporaryToSnapshot = false;
        boolean takeTemporaryFromSnapshot = false;
        if (toSnapshot.isEmpty()) {
            takeTemporaryToSnapshot = true;
            toSnapshot = this.createSnapshot(snapshotDir.toString(), OzoneFSUtils.generateUniqueTempSnapshotName());
        }
        if (fromSnapshot.isEmpty()) {
            takeTemporaryFromSnapshot = true;
            fromSnapshot = this.createSnapshot(snapshotDir.toString(), OzoneFSUtils.generateUniqueTempSnapshotName());
        }
        try {
            SnapshotDiffReportOzone report;
            SnapshotDiffReportOzone aggregated = report = this.getSnapshotDiffReportOnceComplete(fromSnapshot, toSnapshot, "");
            while (StringUtils.isNotEmpty((CharSequence)report.getToken())) {
                LOG.info("Total Snapshot Diff length between snapshot {} and {} exceeds max page size, Performing another snapdiff with index at {}", new Object[]{fromSnapshot, toSnapshot, report.getToken()});
                report = this.getSnapshotDiffReportOnceComplete(fromSnapshot, toSnapshot, report.getToken());
                aggregated.aggregate(report);
            }
            SnapshotDiffReportOzone snapshotDiffReportOzone = aggregated;
            return snapshotDiffReportOzone;
        }
        finally {
            if (takeTemporaryToSnapshot || takeTemporaryFromSnapshot) {
                if (takeTemporaryToSnapshot) {
                    OzoneClientUtils.deleteSnapshot((ObjectStore)this.objectStore, (String)toSnapshot, (String)this.volume.getName(), (String)this.bucket.getName());
                }
                if (takeTemporaryFromSnapshot) {
                    OzoneClientUtils.deleteSnapshot((ObjectStore)this.objectStore, (String)fromSnapshot, (String)this.volume.getName(), (String)this.bucket.getName());
                }
            }
        }
    }

    private SnapshotDiffReportOzone getSnapshotDiffReportOnceComplete(String fromSnapshot, String toSnapshot, String token) throws IOException, InterruptedException {
        SnapshotDiffResponse snapshotDiffResponse;
        while ((snapshotDiffResponse = this.objectStore.snapshotDiff(this.volume.getName(), this.bucket.getName(), fromSnapshot, toSnapshot, token, -1, false, false)).getJobStatus() != SnapshotDiffResponse.JobStatus.DONE) {
            Thread.sleep(snapshotDiffResponse.getWaitTimeInMs());
        }
        return snapshotDiffResponse.getSnapshotDiffReport();
    }

    @Override
    public LeaseKeyInfo recoverFilePrepare(String pathStr, boolean force) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_RECOVER_FILE_PREPARE, 1L);
        try {
            ClientProtocol clientProtocol = this.ozoneClient.getProxy();
            return clientProtocol.recoverLease(this.volume.getName(), this.bucket.getName(), pathStr, force);
        }
        catch (OMException ome) {
            if (ome.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                throw new FileNotFoundException("Path is not a file. " + ome.getMessage());
            }
            if (ome.getResult() == OMException.ResultCodes.KEY_NOT_FOUND || ome.getResult() == OMException.ResultCodes.DIRECTORY_NOT_FOUND) {
                throw new FileNotFoundException("File does not exist. " + ome.getMessage());
            }
            throw ome;
        }
    }

    @Override
    public void recoverFile(OmKeyArgs keyArgs) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_RECOVER_FILE, 1L);
        ClientProtocol clientProtocol = this.ozoneClient.getProxy();
        clientProtocol.recoverKey(keyArgs, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long finalizeBlock(OmKeyLocationInfo block) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_FINALIZE_BLOCK, 1L);
        RpcClient rpcClient = (RpcClient)this.ozoneClient.getProxy();
        XceiverClientFactory xceiverClientFactory = rpcClient.getXceiverClientManager();
        Pipeline pipeline = block.getPipeline();
        XceiverClientSpi client = null;
        try {
            if (pipeline.isOpen()) {
                client = xceiverClientFactory.acquireClient(pipeline);
                ContainerProtos.FinalizeBlockResponseProto finalizeBlockResponseProto = ContainerProtocolCalls.finalizeBlock((XceiverClientSpi)client, (ContainerProtos.DatanodeBlockID)block.getBlockID().getDatanodeBlockIDProtobuf(), (Token)block.getToken());
                long l = BlockData.getFromProtoBuf((ContainerProtos.BlockData)finalizeBlockResponseProto.getBlockData()).getSize();
                return l;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to execute finalizeBlock command", (Throwable)e);
        }
        finally {
            if (client != null) {
                xceiverClientFactory.releaseClient(client, false);
            }
        }
        ReplicationConfig replicationConfig = pipeline.getReplicationConfig();
        if (!(replicationConfig instanceof ReplicatedReplicationConfig)) {
            throw new IOException("ReplicationConfig type " + replicationConfig.getClass().getSimpleName() + " is not supported in finalizeBlock");
        }
        StandaloneReplicationConfig newConfig = StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)((ReplicatedReplicationConfig)replicationConfig).getReplicationFactor());
        Pipeline.Builder builder = Pipeline.newBuilder().setReplicationConfig((ReplicationConfig)newConfig).setId(PipelineID.randomId()).setNodes(block.getPipeline().getNodes()).setState(Pipeline.PipelineState.OPEN);
        try {
            client = xceiverClientFactory.acquireClientForReadData(builder.build());
            ContainerProtos.GetCommittedBlockLengthResponseProto responseProto = ContainerProtocolCalls.getCommittedBlockLength((XceiverClientSpi)client, (BlockID)block.getBlockID(), (Token)block.getToken());
            long l = responseProto.getBlockLength();
            return l;
        }
        finally {
            if (client != null) {
                xceiverClientFactory.releaseClient(client, false);
            }
        }
    }

    @Override
    public void setTimes(String key, long mtime, long atime) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_SET_TIMES, 1L);
        this.bucket.setTimes(key, mtime, atime);
    }

    @Override
    public boolean isFileClosed(String pathStr) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_IS_FILE_CLOSED, 1L);
        if (StringUtils.isEmpty((CharSequence)pathStr)) {
            throw new IOException("not a file");
        }
        try {
            OzoneFileStatus status = this.bucket.getFileStatus(pathStr);
            if (!status.isFile()) {
                throw new FileNotFoundException("Path is not a file.");
            }
            return !status.getKeyInfo().isHsync();
        }
        catch (OMException ome) {
            if (ome.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                throw new FileNotFoundException("File does not exist. " + ome.getMessage());
            }
            throw ome;
        }
    }

    @Override
    public boolean setSafeMode(SafeModeAction action, boolean isChecked) throws IOException {
        this.incrementCounter(Statistic.INVOCATION_SET_SAFE_MODE, 1L);
        return this.ozoneClient.getProxy().getOzoneManagerClient().setSafeMode(action, isChecked);
    }

    public static class IteratorAdapter
    implements Iterator<BasicKeyInfo> {
        private Iterator<? extends OzoneKey> original;

        public IteratorAdapter(Iterator<? extends OzoneKey> listKeys) {
            this.original = listKeys;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public BasicKeyInfo next() {
            OzoneKey next = this.original.next();
            if (next == null) {
                return null;
            }
            return new BasicKeyInfo(next.getName(), next.getModificationTime().toEpochMilli(), next.getDataSize());
        }
    }
}

