/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.lock.FlatResource;
import org.apache.hadoop.ozone.om.lock.HierarchicalResourceLockManager;

public class PoolBasedHierarchicalResourceLockManager
implements HierarchicalResourceLockManager {
    private final GenericObjectPool<ReadWriteLock> lockPool;
    private final Map<FlatResource, Map<String, LockReferenceCountPair>> lockMap;

    public PoolBasedHierarchicalResourceLockManager(OzoneConfiguration conf) {
        int softLimit = conf.getInt("ozone.om.hierarchical.resource.locks.soft.limit", 1024);
        int hardLimit = conf.getInt("ozone.om.hierarchical.resource.locks.hard.limit", 10000);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(softLimit);
        config.setMaxTotal(hardLimit);
        config.setBlockWhenExhausted(true);
        this.lockPool = new GenericObjectPool((PooledObjectFactory)new ReadWriteLockFactory(), config);
        this.lockMap = new ConcurrentHashMap<FlatResource, Map<String, LockReferenceCountPair>>();
    }

    private ReadWriteLock operateOnLock(FlatResource resource, String key, Consumer<LockReferenceCountPair> function) throws IOException {
        AtomicReference exception = new AtomicReference();
        Map resourceLockMap = this.lockMap.computeIfAbsent(resource, k -> new ConcurrentHashMap());
        LockReferenceCountPair lockRef = resourceLockMap.compute(key, (k, v) -> {
            if (v == null) {
                try {
                    ReadWriteLock readWriteLock = (ReadWriteLock)this.lockPool.borrowObject();
                    v = new LockReferenceCountPair(readWriteLock);
                }
                catch (Exception e) {
                    exception.set(new IOException("Exception while initializing lock object.", e));
                    return null;
                }
            }
            function.accept((LockReferenceCountPair)v);
            Preconditions.checkState((((LockReferenceCountPair)v).getCount() >= 0 ? 1 : 0) != 0);
            if (((LockReferenceCountPair)v).getCount() == 0) {
                this.lockPool.returnObject((Object)((LockReferenceCountPair)v).getLock());
                return null;
            }
            return v;
        });
        if (exception.get() != null) {
            throw (IOException)exception.get();
        }
        return lockRef == null ? null : lockRef.getLock();
    }

    @Override
    public HierarchicalResourceLockManager.HierarchicalResourceLock acquireReadLock(FlatResource resource, String key) throws IOException {
        return this.acquireLock(resource, key, true);
    }

    @Override
    public HierarchicalResourceLockManager.HierarchicalResourceLock acquireWriteLock(FlatResource resource, String key) throws IOException {
        return this.acquireLock(resource, key, false);
    }

    private HierarchicalResourceLockManager.HierarchicalResourceLock acquireLock(FlatResource resource, String key, boolean isReadLock) throws IOException {
        ReadWriteLock readWriteLock = this.operateOnLock(resource, key, rec$ -> ((LockReferenceCountPair)rec$).increment());
        if (readWriteLock == null) {
            throw new IOException("Unable to acquire " + (isReadLock ? "read" : "write") + " lock on resource " + resource + " and key " + key);
        }
        return new PoolBasedHierarchicalResourceLock(resource, key, isReadLock ? readWriteLock.readLock() : readWriteLock.writeLock());
    }

    @Override
    public void close() {
        this.lockPool.close();
    }

    private static class ReadWriteLockFactory
    extends BasePooledObjectFactory<ReadWriteLock> {
        private ReadWriteLockFactory() {
        }

        public ReadWriteLock create() throws Exception {
            return new ReentrantReadWriteLock();
        }

        public PooledObject<ReadWriteLock> wrap(ReadWriteLock obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }

    private static final class LockReferenceCountPair {
        private int count = 0;
        private ReadWriteLock lock;

        private LockReferenceCountPair(ReadWriteLock lock) {
            this.lock = lock;
        }

        private void increment() {
            ++this.count;
        }

        private void decrement() {
            --this.count;
        }

        private int getCount() {
            return this.count;
        }

        private ReadWriteLock getLock() {
            return this.lock;
        }
    }

    public class PoolBasedHierarchicalResourceLock
    implements HierarchicalResourceLockManager.HierarchicalResourceLock,
    Closeable {
        private boolean isLockAcquired = true;
        private final Lock lock;
        private final FlatResource resource;
        private final String key;

        public PoolBasedHierarchicalResourceLock(FlatResource resource, String key, Lock lock) {
            this.lock = lock;
            this.resource = resource;
            this.key = key;
            this.lock.lock();
        }

        @Override
        public boolean isLockAcquired() {
            return this.isLockAcquired;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.isLockAcquired) {
                this.lock.unlock();
                PoolBasedHierarchicalResourceLockManager.this.operateOnLock(this.resource, this.key, rec$ -> ((LockReferenceCountPair)rec$).decrement());
                this.isLockAcquired = false;
            }
        }
    }
}

