/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.ComponentVersion;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.hdds.cli.DebugSubcommand;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import picocli.CommandLine;

@CommandLine.Command(name="version", description={"Show internal version of Ozone components, as defined in the artifacts where this command is executed.  It does not communicate with any Ozone services.  Run the same command on different nodes to get a cross-component view of versions.  The goal of this command is to help quickly get a glance of the latest features supported by Ozone on the current node."})
public class VersionDebug
implements Callable<Void>,
DebugSubcommand {
    @Override
    public Void call() throws IOException {
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)ImmutableSortedMap.of((Comparable)((Object)"ozone"), (Object)ImmutableSortedMap.of((Comparable)((Object)"revision"), (Object)OzoneVersionInfo.OZONE_VERSION_INFO.getRevision(), (Comparable)((Object)"url"), (Object)OzoneVersionInfo.OZONE_VERSION_INFO.getUrl(), (Comparable)((Object)"version"), (Object)OzoneVersionInfo.OZONE_VERSION_INFO.getVersion()), (Comparable)((Object)"components"), (Object)ImmutableSortedMap.of((Comparable)((Object)"client"), VersionDebug.asMap(ClientVersion.CURRENT), (Comparable)((Object)"datanode"), VersionDebug.asMap(DatanodeVersion.CURRENT), (Comparable)((Object)"om"), VersionDebug.asMap(OzoneManagerVersion.CURRENT)))));
        return null;
    }

    private static <T extends Enum<T>> Map<String, Object> asMap(T version) {
        return ImmutableSortedMap.of((Comparable)((Object)"componentVersion"), (Object)ImmutableSortedMap.of((Comparable)((Object)"name"), (Object)version.name(), (Comparable)((Object)"protoValue"), (Object)((ComponentVersion)version).toProtoValue()));
    }
}

