/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.ratis.shell.cli.sh.RatisShell;
import picocli.CommandLine;

@CommandLine.Command(name="ozone ratis", description={"Shell for running Ratis commands"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class OzoneRatis
extends GenericCli {
    public static void main(String[] argv) throws Exception {
        new OzoneRatis().run(argv);
    }

    public int execute(String[] argv) {
        TracingUtil.initTracing((String)"shell", (ConfigurationSource)this.getOzoneConf());
        String spanName = "ozone ratis" + String.join((CharSequence)" ", argv);
        return (Integer)TracingUtil.executeInNewSpan((String)spanName, () -> {
            RatisShell shell = new RatisShell(System.out);
            return shell.run(argv);
        });
    }
}

