/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;

public final class ReportResult<T> {
    private ReportStatus status;
    private Set<T> missingEntries;
    private Set<T> newEntries;

    private ReportResult(ReportStatus status, Set<T> missingEntries, Set<T> newEntries) {
        this.status = status;
        Preconditions.checkNotNull(missingEntries);
        Preconditions.checkNotNull(newEntries);
        this.missingEntries = missingEntries;
        this.newEntries = newEntries;
    }

    public ReportStatus getStatus() {
        return this.status;
    }

    public Set<T> getMissingEntries() {
        return this.missingEntries;
    }

    public Set<T> getNewEntries() {
        return this.newEntries;
    }

    public static enum ReportStatus {
        ALL_IS_WELL,
        MISSING_ENTRIES,
        NEW_ENTRIES_FOUND,
        MISSING_AND_NEW_ENTRIES_FOUND,
        NEW_DATANODE_FOUND;

    }

    public static class ReportResultBuilder<T> {
        private ReportStatus status;
        private Set<T> missingEntries;
        private Set<T> newEntries;

        public ReportResultBuilder<T> setStatus(ReportStatus newStatus) {
            this.status = newStatus;
            return this;
        }

        public ReportResultBuilder<T> setMissingEntries(Set<T> missingEntriesList) {
            this.missingEntries = missingEntriesList;
            return this;
        }

        public ReportResultBuilder<T> setNewEntries(Set<T> newEntriesList) {
            this.newEntries = newEntriesList;
            return this;
        }

        public ReportResult<T> build() {
            Set<T> nullSafeMissingEntries = this.missingEntries;
            Set<T> nullSafeNewEntries = this.newEntries;
            if (nullSafeNewEntries == null) {
                nullSafeNewEntries = Collections.emptySet();
            }
            if (nullSafeMissingEntries == null) {
                nullSafeMissingEntries = Collections.emptySet();
            }
            return new ReportResult(this.status, nullSafeMissingEntries, nullSafeNewEntries);
        }
    }
}

