/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.RatisContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeMetrics;
import org.apache.hadoop.hdds.scm.safemode.SafeModeRuleFactory;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMSafeModeManager
implements SafeModeManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMSafeModeManager.class);
    private final AtomicReference<SafeModeStatus> status = new AtomicReference<SafeModeStatus>(SafeModeStatus.INITIAL);
    private final Map<String, SafeModeExitRule<?>> exitRules = new HashMap();
    private final Set<String> preCheckRules = new HashSet<String>();
    private final Set<String> validatedRules = new HashSet<String>();
    private final Set<String> validatedPreCheckRules = new HashSet<String>();
    private final SCMServiceManager serviceManager;
    private final SCMContext scmContext;
    private final SafeModeMetrics safeModeMetrics;

    public SCMSafeModeManager(ConfigurationSource conf, NodeManager nodeManager, PipelineManager pipelineManager, ContainerManager containerManager, SCMServiceManager serviceManager, EventQueue eventQueue, SCMContext scmContext) {
        this.serviceManager = serviceManager;
        this.scmContext = scmContext;
        this.safeModeMetrics = SafeModeMetrics.create();
        SafeModeRuleFactory.initialize(conf, scmContext, eventQueue, pipelineManager, containerManager, nodeManager);
        SafeModeRuleFactory factory = SafeModeRuleFactory.getInstance();
        factory.addSafeModeManager(this);
        factory.getSafeModeRules().forEach(rule -> this.exitRules.put(rule.getRuleName(), (SafeModeExitRule<?>)rule));
        factory.getPreCheckRules().forEach(rule -> this.preCheckRules.add(rule.getRuleName()));
        boolean isSafeModeEnabled = conf.getBoolean("hdds.scm.safemode.enabled", true);
        if (!isSafeModeEnabled) {
            LOG.info("Safemode is disabled, skipping Safemode rule validation and force exiting Safemode.");
            this.status.set(SafeModeStatus.OUT_OF_SAFE_MODE);
            this.emitSafeModeStatus();
        }
    }

    public void start() {
        this.emitSafeModeStatus();
    }

    public void stop() {
        this.safeModeMetrics.unRegister();
    }

    public SafeModeMetrics getSafeModeMetrics() {
        return this.safeModeMetrics;
    }

    private void emitSafeModeStatus() {
        SafeModeStatus safeModeStatus = this.status.get();
        this.scmContext.updateSafeModeStatus(safeModeStatus);
        if (!safeModeStatus.isInSafeMode()) {
            this.serviceManager.notifyStatusChanged();
        } else if (safeModeStatus.isPreCheckComplete()) {
            this.serviceManager.notifyEventTriggered(SCMService.Event.PRE_CHECK_COMPLETED);
        }
    }

    public synchronized void validateSafeModeExitRules(String ruleName) {
        if (this.exitRules.containsKey(ruleName)) {
            this.validatedRules.add(ruleName);
            LOG.info("{} rule is successfully validated", (Object)ruleName);
            if (this.preCheckRules.contains(ruleName)) {
                this.validatedPreCheckRules.add(ruleName);
            }
        } else {
            LOG.error("No Such Exit rule {}", (Object)ruleName);
        }
        if (this.validatedPreCheckRules.size() == this.preCheckRules.size() && this.status.compareAndSet(SafeModeStatus.INITIAL, SafeModeStatus.PRE_CHECKS_PASSED)) {
            LOG.info("All SCM safe mode pre check rules have passed");
            this.emitSafeModeStatus();
        }
        if (this.validatedRules.size() == this.exitRules.size() && this.status.compareAndSet(SafeModeStatus.PRE_CHECKS_PASSED, SafeModeStatus.OUT_OF_SAFE_MODE)) {
            LOG.info("ScmSafeModeManager, all rules are successfully validated");
            LOG.info("SCM exiting safe mode.");
            this.emitSafeModeStatus();
        }
    }

    public void forceExitSafeMode() {
        LOG.info("SCM force-exiting safe mode.");
        this.status.set(SafeModeStatus.OUT_OF_SAFE_MODE);
        this.emitSafeModeStatus();
    }

    public void refresh() {
        if (this.getInSafeMode()) {
            this.exitRules.values().forEach(rule -> rule.refresh(true));
        }
    }

    public void refreshAndValidate() {
        if (this.getInSafeMode()) {
            this.exitRules.values().forEach(rule -> {
                rule.refresh(false);
                if (rule.validate() && this.getInSafeMode()) {
                    this.validateSafeModeExitRules(rule.getRuleName());
                    rule.cleanup();
                }
            });
        }
    }

    @Override
    public boolean getInSafeMode() {
        return this.status.get().isInSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getRuleStatus() {
        HashMap<String, Pair<Boolean, String>> map = new HashMap<String, Pair<Boolean, String>>();
        for (SafeModeExitRule<?> exitRule : this.exitRules.values()) {
            map.put(exitRule.getRuleName(), (Pair<Boolean, String>)Pair.of((Object)exitRule.validate(), (Object)exitRule.getStatusText()));
        }
        return map;
    }

    public boolean getPreCheckComplete() {
        return this.status.get().isPreCheckComplete();
    }

    public static Logger getLogger() {
        return LOG;
    }

    public double getCurrentContainerThreshold() {
        return ((RatisContainerSafeModeRule)this.exitRules.get("RatisContainerSafeModeRule")).getCurrentContainerThreshold();
    }

    public static enum SafeModeStatus {
        INITIAL(true, false),
        PRE_CHECKS_PASSED(true, true),
        OUT_OF_SAFE_MODE(false, true);

        private final boolean safeModeStatus;
        private final boolean preCheckPassed;

        private SafeModeStatus(boolean safeModeState, boolean preCheckPassed) {
            this.safeModeStatus = safeModeState;
            this.preCheckPassed = preCheckPassed;
        }

        public boolean isInSafeMode() {
            return this.safeModeStatus;
        }

        public boolean isPreCheckComplete() {
            return this.preCheckPassed;
        }

        public String toString() {
            return "SafeModeStatus{safeModeStatus=" + this.safeModeStatus + ", preCheckPassed=" + this.preCheckPassed + '}';
        }
    }
}

