/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.shell.MandatoryReplicationOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import picocli.CommandLine;

@CommandLine.Command(name="rewrite", description={"Rewrites the key with different replication"})
public class RewriteKeyHandler
extends KeyHandler {
    @CommandLine.Mixin
    private MandatoryReplicationOptions replication;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        OzoneKeyDetails key = bucket.getKey(keyName);
        ReplicationConfig newReplication = this.replication.fromParamsOrConfig((ConfigurationSource)this.getConf());
        if (newReplication == null || newReplication.equals((Object)key.getReplicationConfig())) {
            System.err.println("Replication unchanged: " + key.getReplicationConfig());
            return;
        }
        try (OzoneInputStream input = bucket.readKey(keyName);
             OzoneOutputStream output = bucket.rewriteKey(keyName, key.getDataSize(), key.getGeneration().longValue(), newReplication, key.getMetadata());){
            IOUtils.copyBytes((InputStream)input, (OutputStream)output, (int)((int)Math.min(0x100000L, key.getDataSize())));
        }
    }
}

