/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.RangerAuditWriter;
import org.apache.ranger.audit.utils.RollingTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRangerAuditWriter
implements RangerAuditWriter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRangerAuditWriter.class);
    public static final String PROP_FILESYSTEM_DIR = "dir";
    public static final String PROP_FILESYSTEM_SUBDIR = "subdir";
    public static final String PROP_FILESYSTEM_FILE_NAME_FORMAT = "filename.format";
    public static final String PROP_FILESYSTEM_FILE_ROLLOVER = "file.rollover.sec";
    public static final String PROP_FILESYSTEM_ROLLOVER_PERIOD = "file.rollover.period";
    public static final String PROP_FILESYSTEM_FILE_EXTENSION = ".log";
    public Configuration conf = null;
    public FileSystem fileSystem = null;
    public Map<String, String> auditConfigs = null;
    public Path auditPath = null;
    public PrintWriter logWriter = null;
    public RollingTimeUtil rollingTimeUtil = null;
    public String auditProviderName = null;
    public String fullPath = null;
    public String parentFolder = null;
    public String currentFileName = null;
    public String logFileNameFormat = null;
    public String logFolder = null;
    public String fileExtension = null;
    public String rolloverPeriod = null;
    public String fileSystemScheme = null;
    public Date nextRollOverTime = null;
    public int fileRolloverSec = 86400;
    public boolean rollOverByDuration = false;
    public volatile FSDataOutputStream ostream = null;
    private boolean isHFlushCapableStream = false;
    protected boolean reUseLastLogFile = false;

    @Override
    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) {
        logger.info("==> AbstractRangerAuditWriter.init()");
        this.auditProviderName = auditProviderName;
        this.auditConfigs = auditConfigs;
        this.init(props, propPrefix);
        logger.info("<== AbstractRangerAuditWriter.init()");
    }

    public void createFileSystemFolders() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.createFileSystemFolders()");
        }
        Date currentTime = new Date();
        String fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
        this.parentFolder = MiscUtil.replaceTokens(this.logFolder, currentTime.getTime());
        String defaultPath = this.fullPath = this.parentFolder + "/" + fileName;
        this.conf = this.createConfiguration();
        URI uri = URI.create(this.fullPath);
        this.fileSystem = FileSystem.get((URI)uri, (Configuration)this.conf);
        this.auditPath = new Path(this.fullPath);
        this.fileSystemScheme = this.getFileSystemScheme();
        logger.info("Checking whether log file exists. " + this.fileSystemScheme + "Path= " + this.fullPath + ", UGI=" + MiscUtil.getUGILoginUser());
        int i = 0;
        while (this.fileSystem.exists(this.auditPath)) {
            int lastDot = defaultPath.lastIndexOf(46);
            String baseName = defaultPath.substring(0, lastDot);
            String extension = defaultPath.substring(lastDot);
            this.fullPath = baseName + "." + ++i + extension;
            this.auditPath = new Path(this.fullPath);
            logger.info("Checking whether log file exists. " + this.fileSystemScheme + "Path= " + this.fullPath);
        }
        logger.info("Log file doesn't exists. Will create and use it. " + this.fileSystemScheme + "Path= " + this.fullPath);
        this.createParents(this.auditPath, this.fileSystem);
        this.currentFileName = this.fullPath;
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.createFileSystemFolders()");
        }
    }

    public Configuration createConfiguration() {
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : this.auditConfigs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isNotEmpty((String)value)) {
                conf.set(key, value);
            }
            logger.info("Adding property to " + this.fileSystemScheme + " + config: " + key + " => " + value);
        }
        logger.info("Returning " + this.fileSystemScheme + "Filesystem Config: " + conf.toString());
        return conf;
    }

    public void createParents(Path pathLogfile, FileSystem fileSystem) throws Exception {
        Path parentPath;
        logger.info("Creating parent folder for " + pathLogfile);
        Path path = parentPath = pathLogfile != null ? pathLogfile.getParent() : null;
        if (parentPath != null && fileSystem != null && !fileSystem.exists(parentPath)) {
            fileSystem.mkdirs(parentPath);
        }
    }

    public void init(Properties props, String propPrefix) {
        String logFolderProp;
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.init()");
        }
        if (StringUtils.isEmpty((String)(logFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILESYSTEM_DIR)))) {
            logger.error("File destination folder is not configured. Please set " + propPrefix + "." + PROP_FILESYSTEM_DIR + ". name=" + this.auditProviderName);
            return;
        }
        String logSubFolder = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILESYSTEM_SUBDIR);
        if (StringUtils.isEmpty((String)logSubFolder)) {
            logSubFolder = "%app-type%/%time:yyyyMMdd%";
        }
        this.logFileNameFormat = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILESYSTEM_FILE_NAME_FORMAT);
        this.fileRolloverSec = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILESYSTEM_FILE_ROLLOVER, this.fileRolloverSec);
        if (StringUtils.isEmpty((String)this.fileExtension)) {
            this.setFileExtension(PROP_FILESYSTEM_FILE_EXTENSION);
        }
        if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
            this.logFileNameFormat = "%app-type%_ranger_audit_%hostname%" + this.fileExtension;
        }
        this.logFolder = logFolderProp + "/" + logSubFolder;
        logger.info("logFolder=" + this.logFolder + ", destName=" + this.auditProviderName);
        logger.info("logFileNameFormat=" + this.logFileNameFormat + ", destName=" + this.auditProviderName);
        logger.info("config=" + this.auditConfigs.toString());
        this.rolloverPeriod = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILESYSTEM_ROLLOVER_PERIOD);
        this.rollingTimeUtil = RollingTimeUtil.getInstance();
        if (StringUtils.isEmpty((String)this.rolloverPeriod)) {
            this.rolloverPeriod = this.rollingTimeUtil.convertRolloverSecondsToRolloverPeriod(this.fileRolloverSec);
        }
        try {
            this.nextRollOverTime = this.rollingTimeUtil.computeNextRollingTime(this.rolloverPeriod);
        }
        catch (Exception e) {
            logger.warn("Rollover by file.rollover.period failed...will be using the file.rollover.sec for " + this.fileSystemScheme + " audit file rollover...", (Throwable)e);
            this.rollOverByDuration = true;
            this.nextRollOverTime = this.rollOverByDuration();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.init()");
        }
    }

    public void closeFileIfNeeded() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.closeFileIfNeeded()");
        }
        if (this.logWriter == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Log writer is null, aborting rollover condition check!");
            }
            return;
        }
        if (System.currentTimeMillis() >= this.nextRollOverTime.getTime()) {
            logger.info("Closing file. Rolling over. name = {}, fileName = {}", (Object)this.auditProviderName, (Object)this.currentFileName);
            this.logWriter.flush();
            this.closeWriter();
            this.resetWriter();
            this.currentFileName = null;
            this.reUseLastLogFile = false;
            if (!this.rollOverByDuration) {
                try {
                    if (StringUtils.isEmpty((String)this.rolloverPeriod)) {
                        this.rolloverPeriod = this.rollingTimeUtil.convertRolloverSecondsToRolloverPeriod(this.fileRolloverSec);
                    }
                    this.nextRollOverTime = this.rollingTimeUtil.computeNextRollingTime(this.rolloverPeriod);
                }
                catch (Exception e) {
                    logger.warn("Rollover by file.rollover.period failed", (Throwable)e);
                    logger.warn("Using the file.rollover.sec for {} audit file rollover...", (Object)this.fileSystemScheme);
                    this.nextRollOverTime = this.rollOverByDuration();
                }
            } else {
                this.nextRollOverTime = this.rollOverByDuration();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.closeFileIfNeeded()");
        }
    }

    public Date rollOverByDuration() {
        long rollOverTime = this.rollingTimeUtil.computeNextRollingTime(this.fileRolloverSec, this.nextRollOverTime);
        return new Date(rollOverTime);
    }

    public PrintWriter createWriter() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.createWriter()");
        }
        if (this.logWriter == null) {
            boolean appendMode = false;
            if (this.reUseLastLogFile && this.fileSystem.hasPathCapability(this.auditPath, "fs.capability.paths.append")) {
                logger.info("Appending to last log file. auditPath = {}", (Object)this.fullPath);
                try {
                    this.ostream = this.fileSystem.append(this.auditPath);
                    appendMode = true;
                }
                catch (Exception e) {
                    logger.error("Failed to append to file {} due to {}", (Object)this.fullPath, (Object)e.getMessage());
                    logger.info("Falling back to create a new log file!");
                    appendMode = false;
                }
            }
            if (!appendMode) {
                logger.info("Creating new log file. auditPath = {}", (Object)this.fullPath);
                this.createFileSystemFolders();
                this.ostream = this.fileSystem.create(this.auditPath);
            }
            this.logWriter = new PrintWriter((OutputStream)this.ostream);
            this.isHFlushCapableStream = this.ostream.hasCapability("hflush");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.createWriter()");
        }
        return this.logWriter;
    }

    public void closeWriter() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.closeWriter()");
        }
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException e) {
                logger.error("Error closing the stream {}", (Object)e.getMessage());
            }
        }
        if (this.logWriter != null) {
            this.logWriter.close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.closeWriter()");
        }
    }

    public void resetWriter() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.resetWriter()");
        }
        this.logWriter = null;
        this.ostream = null;
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.resetWriter()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.flush() " + this.fileSystemScheme);
        }
        if (this.ostream != null) {
            try {
                AbstractRangerAuditWriter abstractRangerAuditWriter = this;
                synchronized (abstractRangerAuditWriter) {
                    if (this.ostream != null) {
                        if (this.isHFlushCapableStream) {
                            this.ostream.hflush();
                        } else {
                            this.ostream.flush();
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Flush " + this.fileSystemScheme + " audit logs completed.....");
                    }
                }
            }
            catch (IOException e) {
                logger.error("Error on flushing log writer: " + e.getMessage() + "\nException will be ignored. name=" + this.auditProviderName + ", fileName=" + this.currentFileName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.flush()");
        }
    }

    public boolean logFileToHDFS(File file) throws Exception {
        boolean ret = false;
        if (logger.isDebugEnabled()) {
            logger.debug("==> AbstractRangerAuditWriter.logFileToHDFS()");
        }
        if (this.logWriter == null) {
            this.createFileSystemFolders();
            logger.info("Copying the Audit File" + file.getName() + " to HDFS Path" + this.fullPath);
            Path destPath = new Path(this.fullPath);
            ret = FileUtil.copy((File)file, (FileSystem)this.fileSystem, (Path)destPath, (boolean)false, (Configuration)this.conf);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AbstractRangerAuditWriter.logFileToHDFS()");
        }
        return ret;
    }

    public String getFileSystemScheme() {
        String ret = null;
        ret = this.logFolder.substring(0, this.logFolder.indexOf(":"));
        ret = ret.toUpperCase();
        return ret;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }
}

