/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.GenericObjectWrapper;
import org.apache.pulsar.client.impl.schema.InstantSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.LocalDateSchema;
import org.apache.pulsar.client.impl.schema.LocalDateTimeSchema;
import org.apache.pulsar.client.impl.schema.LocalTimeSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConsumeSchema
implements Schema<GenericRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoConsumeSchema.class);
    private final ConcurrentMap<SchemaVersion, Schema<?>> schemaMap = this.initSchemaMap();
    private String topicName;
    private String componentName;
    private SchemaInfoProvider schemaInfoProvider;
    public static final SchemaInfo SCHEMA_INFO = SchemaInfoImpl.builder().name("AutoConsume").type(SchemaType.AUTO_CONSUME).schema(new byte[0]).build();

    private ConcurrentMap<SchemaVersion, Schema<?>> initSchemaMap() {
        ConcurrentHashMap schemaMap = new ConcurrentHashMap();
        schemaMap.put((SchemaVersion)BytesSchemaVersion.of((byte[])new byte[0]), (Schema<?>)Schema.BYTES);
        return schemaMap;
    }

    public void setSchema(SchemaVersion schemaVersion, Schema<?> schema) {
        this.schemaMap.put(schemaVersion, schema);
    }

    public void setSchema(Schema<?> schema) {
        this.schemaMap.put(SchemaVersion.Latest, schema);
    }

    private void ensureSchemaInitialized(SchemaVersion schemaVersion) {
        Preconditions.checkState((boolean)this.schemaMap.containsKey(schemaVersion), (Object)("Schema version " + schemaVersion + " is not initialized before used"));
    }

    public void validate(byte[] message) {
        this.ensureSchemaInitialized(SchemaVersion.Latest);
        ((Schema)this.schemaMap.get(SchemaVersion.Latest)).validate(message);
    }

    public void validate(byte[] message, byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.ensureSchemaInitialized(sv);
        ((Schema)this.schemaMap.get(sv)).validate(message);
    }

    public byte[] encode(GenericRecord message) {
        throw new UnsupportedOperationException("AutoConsumeSchema is not intended to be used for encoding");
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    public Schema<?> atSchemaVersion(byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.fetchSchemaIfNeeded(sv);
        this.ensureSchemaInitialized(sv);
        Schema topicVersionedSchema = (Schema)this.schemaMap.get(sv);
        if (topicVersionedSchema.supportSchemaVersioning() && topicVersionedSchema instanceof AbstractSchema) {
            return ((AbstractSchema)topicVersionedSchema).atSchemaVersion(schemaVersion);
        }
        return topicVersionedSchema;
    }

    public GenericRecord decode(byte[] bytes, byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.fetchSchemaIfNeeded(sv);
        this.ensureSchemaInitialized(sv);
        return this.adapt(((Schema)this.schemaMap.get(sv)).decode(bytes, schemaVersion), schemaVersion);
    }

    public GenericRecord decode(ByteBuffer buffer, byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        this.fetchSchemaIfNeeded(sv);
        this.ensureSchemaInitialized(sv);
        return this.adapt(((Schema)this.schemaMap.get(sv)).decode(buffer, schemaVersion), schemaVersion);
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
        for (Schema schema : this.schemaMap.values()) {
            schema.setSchemaInfoProvider(schemaInfoProvider);
        }
    }

    public SchemaInfo getSchemaInfo() {
        if (!this.schemaMap.containsKey(SchemaVersion.Latest)) {
            return null;
        }
        return ((Schema)this.schemaMap.get(SchemaVersion.Latest)).getSchemaInfo();
    }

    public SchemaInfo getSchemaInfo(byte[] schemaVersion) {
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        if (this.schemaMap.containsKey(sv)) {
            return ((Schema)this.schemaMap.get(sv)).getSchemaInfo();
        }
        return null;
    }

    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        this.topicName = topicName;
        this.componentName = componentName;
        if (schemaInfo != null) {
            Schema<?> genericSchema = AutoConsumeSchema.generateSchema(schemaInfo);
            this.setSchema(SchemaVersion.Latest, genericSchema);
            log.info("Configure {} schema for topic {} : {}", new Object[]{componentName, topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    public Optional<Object> getNativeSchema() {
        this.ensureSchemaInitialized(SchemaVersion.Latest);
        if (this.schemaMap.get(SchemaVersion.Latest) == null) {
            return Optional.empty();
        }
        return ((Schema)this.schemaMap.get(SchemaVersion.Latest)).getNativeSchema();
    }

    private static Schema<?> generateSchema(SchemaInfo schemaInfo) {
        boolean useProvidedSchemaAsReaderSchema = false;
        switch (schemaInfo.getType()) {
            case JSON: 
            case AVRO: {
                return AutoConsumeSchema.extractFromAvroSchema(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo, false);
            }
        }
        return AutoConsumeSchema.getSchema(schemaInfo);
    }

    private static Schema<?> extractFromAvroSchema(SchemaInfo schemaInfo, boolean useProvidedSchemaAsReaderSchema) {
        org.apache.avro.Schema avroSchema = SchemaUtil.parseAvroSchema(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8));
        if (avroSchema.getType() == Schema.Type.RECORD) {
            return GenericSchemaImpl.of(schemaInfo, useProvidedSchemaAsReaderSchema);
        }
        if (schemaInfo.getType() == SchemaType.JSON) {
            return Schema.JSON((SchemaDefinition)SchemaDefinition.builder().withPojo(ReflectData.get().getClass(avroSchema)).build());
        }
        return Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withJsonDef(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8)).build());
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case INT8: {
                return ByteSchema.of();
            }
            case INT16: {
                return ShortSchema.of();
            }
            case INT32: {
                return IntSchema.of();
            }
            case INT64: {
                return LongSchema.of();
            }
            case STRING: {
                return StringSchema.utf8();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case BOOLEAN: {
                return BooleanSchema.of();
            }
            case BYTES: 
            case NONE: {
                return BytesSchema.of();
            }
            case DATE: {
                return DateSchema.of();
            }
            case TIME: {
                return TimeSchema.of();
            }
            case TIMESTAMP: {
                return TimestampSchema.of();
            }
            case INSTANT: {
                return InstantSchema.of();
            }
            case LOCAL_DATE: {
                return LocalDateSchema.of();
            }
            case LOCAL_TIME: {
                return LocalTimeSchema.of();
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeSchema.of();
            }
            case JSON: 
            case AVRO: {
                return GenericSchemaImpl.of(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo);
            }
            case KEY_VALUE: {
                KeyValue kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)schemaInfo);
                Schema<?> keySchema = AutoConsumeSchema.getSchema((SchemaInfo)kvSchemaInfo.getKey());
                Schema<?> valueSchema = AutoConsumeSchema.getSchema((SchemaInfo)kvSchemaInfo.getValue());
                return KeyValueSchemaImpl.of(keySchema, valueSchema, KeyValueSchemaInfo.decodeKeyValueEncodingType((SchemaInfo)schemaInfo));
            }
        }
        throw new IllegalArgumentException("Retrieve schema instance from schema info for type '" + schemaInfo.getType() + "' is not supported yet");
    }

    public Schema<GenericRecord> clone() {
        AutoConsumeSchema schema = new AutoConsumeSchema();
        schema.configureSchemaInfo(this.topicName, this.componentName, null);
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        for (Map.Entry entry : this.schemaMap.entrySet()) {
            schema.setSchema((SchemaVersion)entry.getKey(), (Schema)entry.getValue());
        }
        return schema;
    }

    public boolean requireFetchingSchemaInfo() {
        return true;
    }

    protected GenericRecord adapt(Object value, byte[] schemaVersion) {
        if (value instanceof GenericRecord) {
            return (GenericRecord)value;
        }
        SchemaVersion sv = AutoConsumeSchema.getSchemaVersion(schemaVersion);
        if (!this.schemaMap.containsKey(sv)) {
            throw new IllegalStateException("Cannot decode a message without schema");
        }
        return AutoConsumeSchema.wrapPrimitiveObject(value, ((Schema)this.schemaMap.get(sv)).getSchemaInfo().getType(), schemaVersion);
    }

    public static GenericRecord wrapPrimitiveObject(Object value, SchemaType type, byte[] schemaVersion) {
        return GenericObjectWrapper.of(value, type, schemaVersion);
    }

    public Schema<?> getInternalSchema() {
        return (Schema)this.schemaMap.get(SchemaVersion.Latest);
    }

    public Schema<?> getInternalSchema(byte[] schemaVersion) {
        return (Schema)this.schemaMap.get(AutoConsumeSchema.getSchemaVersion(schemaVersion));
    }

    public Schema<?> unwrapInternalSchema(byte[] schemaVersion) {
        this.fetchSchemaIfNeeded((SchemaVersion)BytesSchemaVersion.of((byte[])schemaVersion));
        return this.getInternalSchema(schemaVersion);
    }

    public void fetchSchemaIfNeeded(SchemaVersion schemaVersion) throws SchemaSerializationException {
        if (schemaVersion == null) {
            schemaVersion = BytesSchemaVersion.of((byte[])new byte[0]);
        }
        if (!this.schemaMap.containsKey(schemaVersion)) {
            if (this.schemaInfoProvider == null) {
                throw new SchemaSerializationException("Can't get accurate schema information for topic " + this.topicName + "using AutoConsumeSchema because SchemaInfoProvider is not set yet");
            }
            SchemaInfo schemaInfo = null;
            try {
                schemaInfo = (SchemaInfo)this.schemaInfoProvider.getSchemaByVersion(schemaVersion.bytes()).get();
                if (schemaInfo == null) {
                    schemaInfo = BytesSchema.of().getSchemaInfo();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("Can't get last schema for topic {} using AutoConsumeSchema", (Object)this.topicName);
                throw new SchemaSerializationException(e.getCause());
            }
            Schema<?> schema = AutoConsumeSchema.generateSchema(schemaInfo);
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
            this.setSchema(schemaVersion, schema);
            log.info("Configure {} schema {} for topic {} : {}", new Object[]{this.componentName, schemaVersion, this.topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    private static SchemaVersion getSchemaVersion(byte[] schemaVersion) {
        if (schemaVersion != null) {
            return BytesSchemaVersion.of((byte[])schemaVersion);
        }
        return BytesSchemaVersion.of((byte[])new byte[0]);
    }

    public String toString() {
        if (this.schemaMap.isEmpty()) {
            return "AUTO_CONSUME(uninitialized)";
        }
        StringBuilder sb = new StringBuilder("AUTO_CONSUME(");
        for (Map.Entry entry : this.schemaMap.entrySet()) {
            sb.append("{schemaVersion=").append(entry.getKey()).append(",schemaType=").append(((Schema)entry.getValue()).getSchemaInfo().getType()).append("}");
        }
        sb.append(")");
        return sb.toString();
    }
}

