/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
package org.apache.qpid.server.management.plugin;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public interface ManagementControllerFactory extends Pluggable
{
    String getVersion();

    String getPreviousVersion();

    ManagementController createManagementController(HttpManagementConfiguration<?> httpManagement,
                                                    ManagementController nextVersionManagementController);

    static Map<String, ManagementControllerFactory> loadFactories()
    {
        final Iterable<ManagementControllerFactory> factories =
                new QpidServiceLoader().atLeastOneInstanceOf(ManagementControllerFactory.class);

        return StreamSupport.stream(factories.spliterator(), false)
                            .collect(Collectors.toMap(ManagementControllerFactory::getVersion, f -> f));
    }
}
