/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.TokenBuffer;

public class AsDeductionTypeDeserializer
extends AsPropertyTypeDeserializer {
    private static final BitSet EMPTY_CLASS_FINGERPRINT = new BitSet(0);
    private final Map<String, Integer> propertyBitIndex;
    private final Map<BitSet, String> subtypeFingerprints;

    public AsDeductionTypeDeserializer(DeserializationContext ctxt, JavaType bt, TypeIdResolver idRes, JavaType defaultImpl, Collection<NamedType> subtypes) {
        super(bt, idRes, null, false, defaultImpl, null, true);
        this.propertyBitIndex = new HashMap<String, Integer>();
        this.subtypeFingerprints = this.buildFingerprints(ctxt, subtypes);
    }

    public AsDeductionTypeDeserializer(AsDeductionTypeDeserializer src, BeanProperty property) {
        super(src, property);
        this.propertyBitIndex = src.propertyBitIndex;
        this.subtypeFingerprints = src.subtypeFingerprints;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsDeductionTypeDeserializer(this, prop);
    }

    protected Map<BitSet, String> buildFingerprints(DeserializationContext ctxt, Collection<NamedType> subtypes) {
        boolean ignoreCase = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        int nextProperty = 0;
        HashMap<BitSet, String> fingerprints = new HashMap<BitSet, String>();
        for (NamedType subtype : subtypes) {
            JavaType subtyped = ctxt.constructType(subtype.getType());
            List<BeanPropertyDefinition> properties = ctxt.introspectBeanDescription(subtyped).findProperties();
            BitSet fingerprint = new BitSet(nextProperty + properties.size());
            for (BeanPropertyDefinition property : properties) {
                Integer bitIndex;
                String name = property.getName();
                if (ignoreCase) {
                    name = name.toLowerCase();
                }
                if ((bitIndex = this.propertyBitIndex.get(name)) == null) {
                    bitIndex = nextProperty;
                    this.propertyBitIndex.put(name, nextProperty++);
                }
                for (PropertyName alias : property.findAliases()) {
                    String simpleName = alias.getSimpleName();
                    if (ignoreCase) {
                        simpleName = simpleName.toLowerCase();
                    }
                    if (this.propertyBitIndex.containsKey(simpleName)) continue;
                    this.propertyBitIndex.put(simpleName, bitIndex);
                }
                fingerprint.set(bitIndex);
            }
            String existingFingerprint = fingerprints.put(fingerprint, subtype.getType().getName());
            if (existingFingerprint == null) continue;
            throw new IllegalStateException(String.format("Subtypes %s and %s have the same signature and cannot be uniquely deduced.", existingFingerprint, subtype.getType().getName()));
        }
        return fingerprints;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String emptySubtype;
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        } else if (t != JsonToken.PROPERTY_NAME) {
            return this._deserializeTypedUsingDefaultImpl(p, ctxt, null, "Unexpected input");
        }
        if (t == JsonToken.END_OBJECT && (emptySubtype = this.subtypeFingerprints.get(EMPTY_CLASS_FINGERPRINT)) != null) {
            return this._deserializeTypedForId(p, ctxt, null, emptySubtype);
        }
        LinkedList<BitSet> candidates = new LinkedList<BitSet>(this.subtypeFingerprints.keySet());
        TokenBuffer tb = ctxt.bufferForInputBuffering(p);
        boolean ignoreCase = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (t == JsonToken.PROPERTY_NAME) {
            String name = p.currentName();
            if (ignoreCase) {
                name = name.toLowerCase();
            }
            tb.copyCurrentStructure(p);
            Integer bit = this.propertyBitIndex.get(name);
            if (bit != null) {
                AsDeductionTypeDeserializer.prune(candidates, bit);
                if (candidates.size() == 1) {
                    return this._deserializeTypedForId(p, ctxt, tb, this.subtypeFingerprints.get(candidates.get(0)));
                }
            }
            t = p.nextToken();
        }
        String msgToReportIfDefaultImplFailsToo = String.format("Cannot deduce unique subtype of %s (%d candidates match)", ClassUtil.getTypeDescription(this._baseType), candidates.size());
        return this._deserializeTypedUsingDefaultImpl(p, ctxt, tb, msgToReportIfDefaultImplFailsToo);
    }

    private static void prune(List<BitSet> candidates, int bit) {
        Iterator<BitSet> iter = candidates.iterator();
        while (iter.hasNext()) {
            if (iter.next().get(bit)) continue;
            iter.remove();
        }
    }
}

