/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class ConnectionTune
extends Method {
    public static final int TYPE = 261;
    private short packing_flags = 0;
    private int channelMax;
    private int maxFrameSize;
    private int heartbeatMin;
    private int heartbeatMax;

    @Override
    public final int getStructType() {
        return 261;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionTune() {
    }

    public ConnectionTune(int channelMax, int maxFrameSize, int heartbeatMin, int heartbeatMax, Option ... _options) {
        this.setChannelMax(channelMax);
        this.setMaxFrameSize(maxFrameSize);
        this.setHeartbeatMin(heartbeatMin);
        this.setHeartbeatMax(heartbeatMax);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + String.valueOf((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionTune(context, this);
    }

    public final boolean hasChannelMax() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionTune clearChannelMax() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.channelMax = 0;
        this.setDirty(true);
        return this;
    }

    public final int getChannelMax() {
        return this.channelMax;
    }

    public final ConnectionTune setChannelMax(int value) {
        this.channelMax = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTune channelMax(int value) {
        return this.setChannelMax(value);
    }

    public final boolean hasMaxFrameSize() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionTune clearMaxFrameSize() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.maxFrameSize = 0;
        this.setDirty(true);
        return this;
    }

    public final int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public final ConnectionTune setMaxFrameSize(int value) {
        this.maxFrameSize = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTune maxFrameSize(int value) {
        return this.setMaxFrameSize(value);
    }

    public final boolean hasHeartbeatMin() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ConnectionTune clearHeartbeatMin() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.heartbeatMin = 0;
        this.setDirty(true);
        return this;
    }

    public final int getHeartbeatMin() {
        return this.heartbeatMin;
    }

    public final ConnectionTune setHeartbeatMin(int value) {
        this.heartbeatMin = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTune heartbeatMin(int value) {
        return this.setHeartbeatMin(value);
    }

    public final boolean hasHeartbeatMax() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final ConnectionTune clearHeartbeatMax() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.heartbeatMax = 0;
        this.setDirty(true);
        return this;
    }

    public final int getHeartbeatMax() {
        return this.heartbeatMax;
    }

    public final ConnectionTune setHeartbeatMax(int value) {
        this.heartbeatMax = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.setDirty(true);
        return this;
    }

    public final ConnectionTune heartbeatMax(int value) {
        return this.setHeartbeatMax(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeUint16(this.channelMax);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint16(this.maxFrameSize);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint16(this.heartbeatMin);
        }
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeUint16(this.heartbeatMax);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.channelMax = dec.readUint16();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.maxFrameSize = dec.readUint16();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.heartbeatMin = dec.readUint16();
        }
        if ((this.packing_flags & 0x800) != 0) {
            this.heartbeatMax = dec.readUint16();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("channelMax", this.getChannelMax());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("maxFrameSize", this.getMaxFrameSize());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("heartbeatMin", this.getHeartbeatMin());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("heartbeatMax", this.getHeartbeatMax());
        }
        return result;
    }
}

