/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config.predicates;

import java.util.Objects;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.RulePredicate;
import org.apache.qpid.server.security.access.util.PrefixTree;

class MultiValue
implements RulePredicate {
    private final Property _property;
    private final PrefixTree _tree;

    static RulePredicate newInstance(Property property, PrefixTree tree) {
        return tree == null ? RulePredicate.any() : new MultiValue(property, tree);
    }

    private MultiValue(Property property, PrefixTree tree) {
        this._property = Objects.requireNonNull(property);
        this._tree = Objects.requireNonNull(tree);
    }

    @Override
    public boolean matches(LegacyOperation operation, ObjectProperties objectProperties, Subject subject) {
        Object value = objectProperties.get(this._property);
        return value instanceof String && this._tree.match((String)value);
    }
}

