/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using NUnit.Framework;

namespace Apache.Qpid.Proton.Engine.Implementation
{
   [TestFixture, Timeout(20000)]
   public class ProtonEngineFactoryTest
   {
      [Test]
      public void TestCreateEngine()
      {
         IEngine engine = IEngineFactory.Proton.CreateEngine();

         Assert.AreEqual(EngineState.Idle, engine.EngineState);
         Assert.IsNotNull(engine.SaslDriver);
         Assert.AreEqual(engine.SaslDriver.SaslState, EngineSaslState.Idle);
      }

      [Test]
      public void TestCreateNonSaslEngine()
      {
         IEngine engine = IEngineFactory.Proton.CreateNonSaslEngine();

         Assert.AreEqual(EngineState.Idle, engine.EngineState);
         Assert.IsNotNull(engine.SaslDriver);
         Assert.AreEqual(engine.SaslDriver.SaslState, EngineSaslState.None);
      }
   }
}