/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportMessage;

public abstract class TransportRequest
extends TransportMessage
implements TaskAwareRequest {
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;

    public TransportRequest() {
    }

    public TransportRequest(StreamInput in) throws IOException {
        this.parentTaskId = TaskId.readFromStream(in);
    }

    @Override
    public void setParentTask(TaskId taskId) {
        this.parentTaskId = taskId;
    }

    @Override
    public TaskId getParentTask() {
        return this.parentTaskId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.parentTaskId.writeTo(out);
    }

    public static class Empty
    extends TransportRequest {
        public static final Empty INSTANCE = new Empty();

        public Empty() {
        }

        public Empty(StreamInput in) throws IOException {
            super(in);
        }
    }
}

