/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.policyengine.PerfTestEngine;
import org.apache.ranger.policyengine.RangerAccessRequestDeserializer;
import org.apache.ranger.policyengine.RangerResourceDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestClient
extends Thread {
    static final Logger LOG = LoggerFactory.getLogger(PerfTestClient.class);
    final PerfTestEngine perfTestEngine;
    final int clientId;
    final URL requestFileURL;
    final int maxCycles;
    List<RequestData> requests = null;
    private static Gson gson = null;

    public PerfTestClient(PerfTestEngine perfTestEngine, int clientId, URL requestFileURL, int maxCycles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PerfTestClient(clientId=" + clientId + ", maxCycles=" + maxCycles + ")");
        }
        this.perfTestEngine = perfTestEngine;
        this.clientId = clientId;
        this.requestFileURL = requestFileURL;
        this.maxCycles = maxCycles;
        this.setName("PerfTestClient-" + clientId);
        this.setDaemon(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PerfTestClient(clientId=" + clientId + ", maxCycles=" + maxCycles + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> init()");
        }
        boolean ret = false;
        Reader reader = null;
        try (InputStream in = this.requestFileURL.openStream();){
            reader = new InputStreamReader(in, Charset.forName("UTF-8"));
            Type listType = new TypeToken<List<RequestData>>(){}.getType();
            this.requests = (List)gson.fromJson(reader, listType);
            ret = true;
        }
        catch (Exception excp) {
            LOG.error("Error opening request data stream or loading load request data from file, URL=" + this.requestFileURL, (Throwable)excp);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception excp) {
                    LOG.error("Error closing file ", (Throwable)excp);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== init() : " + ret);
        }
        return ret;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> run()");
        }
        try {
            for (int i = 0; i < this.maxCycles; ++i) {
                for (RequestData data : this.requests) {
                    data.setResult(this.perfTestEngine.execute(data.getRequest()));
                }
            }
        }
        catch (Exception excp) {
            LOG.error("PerfTestClient.run() : interrupted! Exiting thread", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== run()");
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z");
        gson = builder.setPrettyPrinting().registerTypeAdapter(RangerAccessRequest.class, (Object)new RangerAccessRequestDeserializer(builder)).registerTypeAdapter(RangerAccessResource.class, (Object)new RangerResourceDeserializer(builder)).create();
    }

    private static class RequestData {
        private String name;
        private RangerAccessRequest request;
        private RangerAccessResult result;

        public RequestData() {
            this(null, null, null);
        }

        public RequestData(String name, RangerAccessRequest request, RangerAccessResult result) {
            this.setName(name);
            this.setRequest(request);
            this.setResult(result);
        }

        public String getName() {
            return this.name;
        }

        public RangerAccessRequest getRequest() {
            return this.request;
        }

        public RangerAccessResult getResult() {
            return this.result;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRequest(RangerAccessRequest request) {
            this.request = request;
        }

        public void setResult(RangerAccessResult result) {
            this.result = result;
        }
    }
}

