/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class EntityNotificationV1
extends EntityNotification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Referenceable entity;
    private OperationType operationType;
    private List<Struct> traits;

    public EntityNotificationV1() {
    }

    public EntityNotificationV1(Referenceable entity, OperationType operationType, List<Struct> traits) {
        this.entity = entity;
        this.operationType = operationType;
        this.traits = traits;
    }

    public EntityNotificationV1(Referenceable entity, OperationType operationType, AtlasTypeRegistry typeRegistry) {
        this(entity, operationType, EntityNotificationV1.getAllTraits(entity, typeRegistry));
    }

    public Referenceable getEntity() {
        return this.entity;
    }

    public void setEntity(Referenceable entity) {
        this.entity = entity;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public List<Struct> getTraits() {
        return this.traits;
    }

    public void setTraits(List<Struct> traits) {
        this.traits = traits;
    }

    @JsonIgnore
    public List<Struct> getAllTraits() {
        return this.traits;
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.entity != null) {
            this.entity.normalize();
        }
        if (this.traits != null) {
            for (Struct trait : this.traits) {
                if (trait == null) continue;
                trait.normalize();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityNotificationV1 that = (EntityNotificationV1)o;
        return Objects.equals(this.entity, that.entity) && this.operationType == that.operationType && Objects.equals(this.traits, that.traits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entity, this.operationType, this.traits});
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("EntityNotificationV1{");
        super.toString(sb);
        sb.append(", entity=");
        if (this.entity != null) {
            this.entity.toString(sb);
        } else {
            sb.append(this.entity);
        }
        sb.append(", operationType=").append((Object)this.operationType);
        sb.append(", traits=[");
        AtlasBaseTypeDef.dumpObjects(this.traits, sb);
        sb.append("]");
        sb.append("}");
        return sb;
    }

    private static List<Struct> getAllTraits(Referenceable entityDefinition, AtlasTypeRegistry typeRegistry) {
        LinkedList<Struct> ret = new LinkedList<Struct>();
        for (String traitName : entityDefinition.getTraitNames()) {
            Struct trait = entityDefinition.getTrait(traitName);
            AtlasClassificationType traitType = typeRegistry.getClassificationTypeByName(traitName);
            Set<String> superTypeNames = traitType != null ? traitType.getAllSuperTypes() : null;
            ret.add(trait);
            if (!CollectionUtils.isNotEmpty(superTypeNames)) continue;
            for (String superTypeName : superTypeNames) {
                AtlasClassificationType superType;
                Struct superTypeTrait = new Struct(superTypeName);
                if (MapUtils.isNotEmpty(trait.getValues()) && (superType = typeRegistry.getClassificationTypeByName(superTypeName)) != null && MapUtils.isNotEmpty(superType.getAllAttributes())) {
                    HashMap<String, Object> superTypeTraitAttributes = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> attrEntry : trait.getValues().entrySet()) {
                        String attrName = attrEntry.getKey();
                        if (!superType.getAllAttributes().containsKey(attrName)) continue;
                        superTypeTraitAttributes.put(attrName, attrEntry.getValue());
                    }
                    superTypeTrait.setValues(superTypeTraitAttributes);
                }
                ret.add(superTypeTrait);
            }
        }
        return ret;
    }

    public static enum OperationType {
        ENTITY_CREATE,
        ENTITY_UPDATE,
        ENTITY_DELETE,
        TRAIT_ADD,
        TRAIT_DELETE,
        TRAIT_UPDATE;

    }
}

