/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool;

import java.io.File;
import org.apache.atlas.notification.spool.utils.local.FileOpAppend;
import org.apache.atlas.notification.spool.utils.local.FileOpCompaction;
import org.apache.atlas.notification.spool.utils.local.FileOpDelete;
import org.apache.atlas.notification.spool.utils.local.FileOpRead;
import org.apache.atlas.notification.spool.utils.local.FileOpUpdate;

public class FileOperations {
    private final String emptyRecordJson;
    private final FileOpAppend fileOpAppend;
    private final FileOpRead fileOpLoad;
    private final FileOpUpdate fileOpUpdate;
    private final FileOpCompaction fileOpCompaction;
    private final FileOpDelete fileOpDelete;

    public FileOperations(String emptyRecordJson, String source) {
        this.emptyRecordJson = emptyRecordJson;
        this.fileOpAppend = new FileOpAppend(source);
        this.fileOpLoad = new FileOpRead(source);
        this.fileOpUpdate = new FileOpUpdate(source, this.fileOpAppend);
        this.fileOpCompaction = new FileOpCompaction(source);
        this.fileOpDelete = new FileOpDelete(source);
    }

    public String[] load(File file) {
        this.fileOpLoad.perform(file);
        return this.fileOpLoad.getItems();
    }

    public void delete(File file, String id) {
        this.fileOpDelete.perform(file, id, this.emptyRecordJson);
    }

    public void append(File file, String json) {
        this.fileOpAppend.perform(file, json);
    }

    public void compact(File file) {
        this.fileOpCompaction.perform(file);
    }

    public void update(File file, String id, String json) {
        this.fileOpUpdate.setId(id);
        this.fileOpUpdate.perform(file, json);
    }
}

