/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;

public class CastExpression
extends AbstractGroovyExpression {
    private GroovyExpression expr;
    private String className;

    public CastExpression(GroovyExpression expr, String className) {
        this.expr = expr;
        this.className = className;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        context.append("((");
        context.append(this.className);
        context.append(")");
        this.expr.generateGroovy(context);
        context.append(")");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.singletonList(this.expr);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        assert (newChildren.size() == 1);
        return new CastExpression(newChildren.get(0), this.className);
    }
}

