/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.List;
import org.apache.atlas.AtlasException;
import org.apache.atlas.groovy.BinaryExpression;
import org.apache.atlas.groovy.GroovyExpression;

public class ComparisonExpression
extends BinaryExpression {
    public ComparisonExpression(GroovyExpression left, ComparisonOperator op, GroovyExpression right) {
        super(left, op.getGroovyValue(), right);
    }

    private ComparisonExpression(GroovyExpression left, String op, GroovyExpression right) {
        super(left, op, right);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        assert (newChildren.size() == 2);
        return new ComparisonExpression(newChildren.get(0), this.op, newChildren.get(1));
    }

    public static enum ComparisonOperator {
        GREATER_THAN_EQ_(">="),
        GREATER_THAN(">"),
        EQUALS("=="),
        NOT_EQUALS("!="),
        LESS_THAN("<"),
        LESS_THAN_EQ("<=");

        private String groovyValue;

        private ComparisonOperator(String groovyValue) {
            this.groovyValue = groovyValue;
        }

        public String getGroovyValue() {
            return this.groovyValue;
        }

        public static ComparisonOperator lookup(String groovyValue) throws AtlasException {
            for (ComparisonOperator op : ComparisonOperator.values()) {
                if (!op.getGroovyValue().equals(groovyValue)) continue;
                return op;
            }
            throw new AtlasException("Unknown Operator:" + groovyValue);
        }
    }
}

