/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.NetUtils;

public class NettyClient
implements Closeable {
    private final LifeCycle lifeCycle;
    private final String serverAddress;
    private Channel channel;

    NettyClient(String serverAddress) {
        this.lifeCycle = new LifeCycle(JavaUtils.getClassSimpleName(this.getClass()) + "-" + serverAddress);
        this.serverAddress = serverAddress;
    }

    public void connect(EventLoopGroup group, ChannelInitializer<SocketChannel> initializer) throws InterruptedException {
        InetSocketAddress address = NetUtils.createSocketAddr(this.serverAddress);
        this.lifeCycle.startAndTransition(() -> {
            this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NettyUtils.getSocketChannelClass(group))).handler(new LoggingHandler(LogLevel.INFO))).handler(initializer)).connect(address).sync().channel();
        }, InterruptedException.class);
    }

    @Override
    public void close() {
        this.lifeCycle.checkStateAndClose(() -> NettyUtils.closeChannel(this.channel, this.serverAddress));
    }

    public ChannelFuture writeAndFlush(Object msg) {
        this.lifeCycle.assertCurrentState(LifeCycle.States.RUNNING);
        return this.channel.writeAndFlush(msg);
    }

    public String toString() {
        return this.lifeCycle.toString();
    }
}

