/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PivotVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;

public class Pivot
implements Serializable {
    private List<SelectItem<Function>> functionItems;
    private ExpressionList<Column> forColumns;
    private List<SelectItem<?>> singleInItems;
    private List<SelectItem<ExpressionList>> multiInItems;
    private Alias alias;

    public void accept(PivotVisitor pivotVisitor) {
        pivotVisitor.visit(this);
    }

    public List<SelectItem<?>> getSingleInItems() {
        return this.singleInItems;
    }

    public void setSingleInItems(List<SelectItem<?>> singleInItems) {
        this.singleInItems = singleInItems;
    }

    public List<SelectItem<ExpressionList>> getMultiInItems() {
        return this.multiInItems;
    }

    public void setMultiInItems(List<SelectItem<ExpressionList>> multiInItems) {
        this.multiInItems = multiInItems;
    }

    public List<SelectItem<Function>> getFunctionItems() {
        return this.functionItems;
    }

    public void setFunctionItems(List<SelectItem<Function>> functionItems) {
        this.functionItems = functionItems;
    }

    public ExpressionList<Column> getForColumns() {
        return this.forColumns;
    }

    public void setForColumns(ExpressionList<Column> forColumns) {
        this.forColumns = forColumns;
    }

    public List<?> getInItems() {
        return this.singleInItems == null ? this.multiInItems : this.singleInItems;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String toString() {
        return "PIVOT (" + PlainSelect.getStringList(this.functionItems) + " FOR " + PlainSelect.getStringList(this.forColumns, true, this.forColumns != null && this.forColumns.size() > 1) + " IN " + PlainSelect.getStringList(this.getInItems(), true, true) + ")" + (this.alias != null ? this.alias.toString() : "");
    }

    public Pivot withFunctionItems(List<SelectItem<Function>> functionItems) {
        this.setFunctionItems(functionItems);
        return this;
    }

    public Pivot withForColumns(ExpressionList<Column> forColumns) {
        this.setForColumns(forColumns);
        return this;
    }

    public Pivot withSingleInItems(List<SelectItem<?>> singleInItems) {
        this.setSingleInItems(singleInItems);
        return this;
    }

    public Pivot withMultiInItems(List<SelectItem<ExpressionList>> multiInItems) {
        this.setMultiInItems(multiInItems);
        return this;
    }

    public Pivot withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public Pivot addFunctionItems(SelectItem<Function> ... functionItems) {
        List collection = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, functionItems);
        return this.withFunctionItems(collection);
    }

    public Pivot addFunctionItems(Collection<? extends SelectItem<Function>> functionItems) {
        List collection = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        collection.addAll(functionItems);
        return this.withFunctionItems(collection);
    }

    public Pivot addForColumns(Column ... forColumns) {
        return this.addForColumns(Arrays.asList(forColumns));
    }

    public Pivot addForColumns(Collection<? extends Column> forColumns) {
        ExpressionList collection = Optional.ofNullable(this.getForColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        collection.addAll(forColumns);
        return this.withForColumns(collection);
    }

    public Pivot addSingleInItems(SelectItem<?> ... singleInItems) {
        List collection = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, singleInItems);
        return this.withSingleInItems(collection);
    }

    public Pivot addSingleInItems(Collection<? extends SelectItem<?>> singleInItems) {
        List collection = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        collection.addAll(singleInItems);
        return this.withSingleInItems(collection);
    }

    public Pivot addMultiInItems(SelectItem<ExpressionList> ... multiInItems) {
        List collection = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        Collections.addAll(collection, multiInItems);
        return this.withMultiInItems(collection);
    }

    public Pivot addMultiInItems(Collection<? extends SelectItem<ExpressionList>> multiInItems) {
        List collection = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        collection.addAll(multiInItems);
        return this.withMultiInItems(collection);
    }
}

