/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public interface HdfsClientConfigKeys {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final String DFS_BLOCK_SIZE_KEY = "dfs.blocksize";
    public static final long DFS_BLOCK_SIZE_DEFAULT = 0x8000000L;
    public static final String DFS_REPLICATION_KEY = "dfs.replication";
    public static final short DFS_REPLICATION_DEFAULT = 3;
    public static final String DFS_WEBHDFS_USER_PATTERN_KEY = "dfs.webhdfs.user.provider.user.pattern";
    public static final String DFS_WEBHDFS_USER_PATTERN_DEFAULT = "^[A-Za-z_][A-Za-z0-9._-]*[$]?$";
    public static final String DFS_WEBHDFS_ACL_PERMISSION_PATTERN_KEY = "dfs.webhdfs.acl.provider.permission.pattern";
    public static final String DFS_WEBHDFS_ACL_PERMISSION_PATTERN_DEFAULT = "^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$";
    public static final String DFS_WEBHDFS_SOCKET_CONNECT_TIMEOUT_KEY = "dfs.webhdfs.socket.connect-timeout";
    public static final String DFS_WEBHDFS_SOCKET_READ_TIMEOUT_KEY = "dfs.webhdfs.socket.read-timeout";
    public static final String DFS_WEBHDFS_OAUTH_ENABLED_KEY = "dfs.webhdfs.oauth2.enabled";
    public static final boolean DFS_WEBHDFS_OAUTH_ENABLED_DEFAULT = false;
    public static final String DFS_WEBHDFS_REST_CSRF_ENABLED_KEY = "dfs.webhdfs.rest-csrf.enabled";
    public static final boolean DFS_WEBHDFS_REST_CSRF_ENABLED_DEFAULT = false;
    public static final String DFS_WEBHDFS_REST_CSRF_CUSTOM_HEADER_KEY = "dfs.webhdfs.rest-csrf.custom-header";
    public static final String DFS_WEBHDFS_REST_CSRF_CUSTOM_HEADER_DEFAULT = "X-XSRF-HEADER";
    public static final String DFS_WEBHDFS_REST_CSRF_METHODS_TO_IGNORE_KEY = "dfs.webhdfs.rest-csrf.methods-to-ignore";
    public static final String DFS_WEBHDFS_REST_CSRF_METHODS_TO_IGNORE_DEFAULT = "GET,OPTIONS,HEAD,TRACE";
    public static final String DFS_WEBHDFS_REST_CSRF_BROWSER_USERAGENTS_REGEX_KEY = "dfs.webhdfs.rest-csrf.browser-useragents-regex";
    public static final String OAUTH_CLIENT_ID_KEY = "dfs.webhdfs.oauth2.client.id";
    public static final String OAUTH_REFRESH_URL_KEY = "dfs.webhdfs.oauth2.refresh.url";
    public static final String ACCESS_TOKEN_PROVIDER_KEY = "dfs.webhdfs.oauth2.access.token.provider";
    public static final String PREFIX = "dfs.client.";
    public static final String DFS_NAMESERVICES = "dfs.nameservices";
    public static final String DFS_NAMENODE_RPC_ADDRESS_KEY = "dfs.namenode.rpc-address";
    public static final String DFS_NAMENODE_RPC_ADDRESS_AUXILIARY_SUFFIX = "auxiliary-ports";
    public static final String DFS_NAMENODE_RPC_ADDRESS_AUXILIARY_KEY = "dfs.namenode.rpc-address.auxiliary-ports";
    public static final int DFS_NAMENODE_HTTP_PORT_DEFAULT = 9870;
    public static final String DFS_NAMENODE_HTTP_ADDRESS_KEY = "dfs.namenode.http-address";
    public static final int DFS_NAMENODE_HTTPS_PORT_DEFAULT = 9871;
    public static final String DFS_NAMENODE_HTTPS_ADDRESS_KEY = "dfs.namenode.https-address";
    public static final String DFS_HA_NAMENODES_KEY_PREFIX = "dfs.ha.namenodes";
    public static final int DFS_NAMENODE_RPC_PORT_DEFAULT = 8020;
    public static final String DFS_NAMENODE_KERBEROS_PRINCIPAL_KEY = "dfs.namenode.kerberos.principal";
    public static final String DFS_CLIENT_WRITE_PACKET_SIZE_KEY = "dfs.client-write-packet-size";
    public static final int DFS_CLIENT_WRITE_PACKET_SIZE_DEFAULT = 65536;
    public static final String DFS_CLIENT_SOCKET_TIMEOUT_KEY = "dfs.client.socket-timeout";
    public static final String DFS_CLIENT_SOCKET_SEND_BUFFER_SIZE_KEY = "dfs.client.socket.send.buffer.size";
    public static final int DFS_CLIENT_SOCKET_SEND_BUFFER_SIZE_DEFAULT = 0;
    public static final String DFS_CLIENT_SOCKET_CACHE_CAPACITY_KEY = "dfs.client.socketcache.capacity";
    public static final int DFS_CLIENT_SOCKET_CACHE_CAPACITY_DEFAULT = 16;
    public static final String DFS_CLIENT_SOCKET_CACHE_EXPIRY_MSEC_KEY = "dfs.client.socketcache.expiryMsec";
    public static final long DFS_CLIENT_SOCKET_CACHE_EXPIRY_MSEC_DEFAULT = 3000L;
    public static final String DFS_CLIENT_USE_DN_HOSTNAME = "dfs.client.use.datanode.hostname";
    public static final boolean DFS_CLIENT_USE_DN_HOSTNAME_DEFAULT = false;
    public static final String DFS_CLIENT_CACHE_DROP_BEHIND_WRITES = "dfs.client.cache.drop.behind.writes";
    public static final String DFS_CLIENT_CACHE_DROP_BEHIND_READS = "dfs.client.cache.drop.behind.reads";
    public static final String DFS_CLIENT_CACHE_READAHEAD = "dfs.client.cache.readahead";
    public static final String DFS_CLIENT_CACHED_CONN_RETRY_KEY = "dfs.client.cached.conn.retry";
    public static final int DFS_CLIENT_CACHED_CONN_RETRY_DEFAULT = 3;
    public static final String DFS_CLIENT_CONTEXT = "dfs.client.context";
    public static final String DFS_CLIENT_CONTEXT_DEFAULT = "default";
    public static final String DFS_CLIENT_USE_LEGACY_BLOCKREADERLOCAL = "dfs.client.use.legacy.blockreader.local";
    public static final boolean DFS_CLIENT_USE_LEGACY_BLOCKREADERLOCAL_DEFAULT = false;
    public static final String DFS_CLIENT_DATANODE_RESTART_TIMEOUT_KEY = "dfs.client.datanode-restart.timeout";
    public static final long DFS_CLIENT_DATANODE_RESTART_TIMEOUT_DEFAULT = 30L;
    public static final String DFS_CLIENT_MAX_BLOCK_ACQUIRE_FAILURES_KEY = "dfs.client.max.block.acquire.failures";
    public static final int DFS_CLIENT_MAX_BLOCK_ACQUIRE_FAILURES_DEFAULT = 3;
    public static final String DFS_CLIENT_SERVER_DEFAULTS_VALIDITY_PERIOD_MS_KEY = "dfs.client.server-defaults.validity.period.ms";
    public static final long DFS_CLIENT_SERVER_DEFAULTS_VALIDITY_PERIOD_MS_DEFAULT = TimeUnit.HOURS.toMillis(1L);
    public static final String DFS_CHECKSUM_TYPE_KEY = "dfs.checksum.type";
    public static final String DFS_CHECKSUM_TYPE_DEFAULT = "CRC32C";
    public static final String DFS_BYTES_PER_CHECKSUM_KEY = "dfs.bytes-per-checksum";
    public static final int DFS_BYTES_PER_CHECKSUM_DEFAULT = 512;
    public static final String DFS_CHECKSUM_COMBINE_MODE_KEY = "dfs.checksum.combine.mode";
    public static final String DFS_CHECKSUM_COMBINE_MODE_DEFAULT = "MD5MD5CRC";
    public static final String DFS_DATANODE_SOCKET_WRITE_TIMEOUT_KEY = "dfs.datanode.socket.write.timeout";
    public static final String DFS_CLIENT_DOMAIN_SOCKET_DATA_TRAFFIC = "dfs.client.domain.socket.data.traffic";
    public static final boolean DFS_CLIENT_DOMAIN_SOCKET_DATA_TRAFFIC_DEFAULT = false;
    public static final String DFS_DOMAIN_SOCKET_PATH_KEY = "dfs.domain.socket.path";
    public static final String DFS_DOMAIN_SOCKET_PATH_DEFAULT = "";
    public static final String DFS_DOMAIN_SOCKET_DISABLE_INTERVAL_SECOND_KEY = "dfs.domain.socket.disable.interval.seconds";
    public static final long DFS_DOMAIN_SOCKET_DISABLE_INTERVAL_SECOND_DEFAULT = 600L;
    public static final String DFS_SHORT_CIRCUIT_SHARED_MEMORY_WATCHER_INTERRUPT_CHECK_MS = "dfs.short.circuit.shared.memory.watcher.interrupt.check.ms";
    public static final int DFS_SHORT_CIRCUIT_SHARED_MEMORY_WATCHER_INTERRUPT_CHECK_MS_DEFAULT = 60000;
    public static final String DFS_CLIENT_SLOW_IO_WARNING_THRESHOLD_KEY = "dfs.client.slow.io.warning.threshold.ms";
    public static final long DFS_CLIENT_SLOW_IO_WARNING_THRESHOLD_DEFAULT = 30000L;
    public static final String DFS_CLIENT_KEY_PROVIDER_CACHE_EXPIRY_MS = "dfs.client.key.provider.cache.expiry";
    public static final long DFS_CLIENT_KEY_PROVIDER_CACHE_EXPIRY_DEFAULT = TimeUnit.DAYS.toMillis(10L);
    public static final String DFS_CLIENT_REFRESH_READ_BLOCK_LOCATIONS_MS_KEY = "dfs.client.refresh.read-block-locations.ms";
    public static final long DFS_CLIENT_REFRESH_READ_BLOCK_LOCATIONS_MS_DEFAULT = 0L;
    public static final String DFS_DATANODE_KERBEROS_PRINCIPAL_KEY = "dfs.datanode.kerberos.principal";
    public static final String DFS_DATANODE_READAHEAD_BYTES_KEY = "dfs.datanode.readahead.bytes";
    public static final long DFS_DATANODE_READAHEAD_BYTES_DEFAULT = 0x400000L;
    public static final String DFS_ENCRYPT_DATA_TRANSFER_CIPHER_SUITES_KEY = "dfs.encrypt.data.transfer.cipher.suites";
    public static final String DFS_ENCRYPT_DATA_OVERWRITE_DOWNSTREAM_NEW_QOP_KEY = "dfs.encrypt.data.overwrite.downstream.new.qop";
    public static final String DFS_DATA_TRANSFER_PROTECTION_KEY = "dfs.data.transfer.protection";
    public static final String DFS_DATA_TRANSFER_PROTECTION_DEFAULT = "";
    public static final String DFS_DATA_TRANSFER_SASL_PROPS_RESOLVER_CLASS_KEY = "dfs.data.transfer.saslproperties.resolver.class";
    public static final String DFS_ENCRYPT_DATA_TRANSFER_CIPHER_KEY_BITLENGTH_KEY = "dfs.encrypt.data.transfer.cipher.key.bitlength";
    public static final int DFS_ENCRYPT_DATA_TRANSFER_CIPHER_KEY_BITLENGTH_DEFAULT = 128;
    public static final String DFS_TRUSTEDCHANNEL_RESOLVER_CLASS = "dfs.trustedchannel.resolver.class";
    public static final String REPLICA_ACCESSOR_BUILDER_CLASSES_KEY = "dfs.client.replica.accessor.builder.classes";
    public static final String DFS_CLIENT_TEST_DROP_NAMENODE_RESPONSE_NUM_KEY = "dfs.client.test.drop.namenode.response.number";
    public static final int DFS_CLIENT_TEST_DROP_NAMENODE_RESPONSE_NUM_DEFAULT = 0;
    public static final String DFS_CLIENT_LOCAL_INTERFACES = "dfs.client.local.interfaces";
    public static final String DFS_USER_HOME_DIR_PREFIX_KEY = "dfs.user.home.dir.prefix";
    public static final String DFS_USER_HOME_DIR_PREFIX_DEFAULT = "/user";
    public static final String DFS_DATA_TRANSFER_CLIENT_TCPNODELAY_KEY = "dfs.data.transfer.client.tcpnodelay";
    public static final boolean DFS_DATA_TRANSFER_CLIENT_TCPNODELAY_DEFAULT = true;
    public static final String DFS_NAMENODE_SNAPSHOT_CAPTURE_OPENFILES = "dfs.namenode.snapshot.capture.openfiles";
    public static final boolean DFS_NAMENODE_SNAPSHOT_CAPTURE_OPENFILES_DEFAULT = false;
    public static final String DFS_LEASE_HARDLIMIT_KEY = "dfs.namenode.lease-hard-limit-sec";
    public static final long DFS_LEASE_HARDLIMIT_DEFAULT = 1200L;

    public static interface HttpClient {
        public static final String PREFIX = "dfs.http.client.";
        public static final String RETRY_POLICY_ENABLED_KEY = "dfs.http.client.retry.policy.enabled";
        public static final boolean RETRY_POLICY_ENABLED_DEFAULT = false;
        public static final String RETRY_POLICY_SPEC_KEY = "dfs.http.client.retry.policy.spec";
        public static final String RETRY_POLICY_SPEC_DEFAULT = "10000,6,60000,10";
        public static final String RETRY_MAX_ATTEMPTS_KEY = "dfs.http.client.retry.max.attempts";
        public static final int RETRY_MAX_ATTEMPTS_DEFAULT = 10;
        public static final String FAILOVER_MAX_ATTEMPTS_KEY = "dfs.http.client.failover.max.attempts";
        public static final int FAILOVER_MAX_ATTEMPTS_DEFAULT = 15;
        public static final String FAILOVER_SLEEPTIME_BASE_KEY = "dfs.http.client.failover.sleep.base.millis";
        public static final int FAILOVER_SLEEPTIME_BASE_DEFAULT = 500;
        public static final String FAILOVER_SLEEPTIME_MAX_KEY = "dfs.http.client.failover.sleep.max.millis";
        public static final int FAILOVER_SLEEPTIME_MAX_DEFAULT = 15000;
    }

    public static interface StripedRead {
        public static final String PREFIX = "dfs.client.read.striped.";
        public static final String THREADPOOL_SIZE_KEY = "dfs.client.read.striped.threadpool.size";
        public static final int THREADPOOL_SIZE_DEFAULT = 18;
    }

    public static interface HedgedRead {
        public static final String PREFIX = "dfs.client.hedged.read.";
        public static final String THRESHOLD_MILLIS_KEY = "dfs.client.hedged.read.threshold.millis";
        public static final long THRESHOLD_MILLIS_DEFAULT = 500L;
        public static final String THREADPOOL_SIZE_KEY = "dfs.client.hedged.read.threadpool.size";
        public static final int THREADPOOL_SIZE_DEFAULT = 0;
    }

    public static interface Mmap {
        public static final String PREFIX = "dfs.client.mmap.";
        public static final String ENABLED_KEY = "dfs.client.mmap.enabled";
        public static final boolean ENABLED_DEFAULT = true;
        public static final String CACHE_SIZE_KEY = "dfs.client.mmap.cache.size";
        public static final int CACHE_SIZE_DEFAULT = 256;
        public static final String CACHE_TIMEOUT_MS_KEY = "dfs.client.mmap.cache.timeout.ms";
        public static final long CACHE_TIMEOUT_MS_DEFAULT = 3600000L;
        public static final String RETRY_TIMEOUT_MS_KEY = "dfs.client.mmap.retry.timeout.ms";
        public static final long RETRY_TIMEOUT_MS_DEFAULT = 300000L;
    }

    public static interface ShortCircuit {
        public static final String PREFIX = "dfs.client.read.short.circuit.";
        public static final String REPLICA_STALE_THRESHOLD_MS_KEY = "dfs.client.read.short.circuit.replica.stale.threshold.ms";
        public static final long REPLICA_STALE_THRESHOLD_MS_DEFAULT = 1800000L;
    }

    public static interface Read {
        public static final String PREFIX = "dfs.client.read.";
        public static final String PREFETCH_SIZE_KEY = "dfs.client.read.prefetch.size";

        public static interface ShortCircuit {
            public static final String PREFIX = "dfs.client.read.shortcircuit.";
            public static final String KEY = "dfs.client.read.shortcircuit.".substring(0, "dfs.client.read.shortcircuit.".length() - 1);
            public static final boolean DEFAULT = false;
            public static final String SKIP_CHECKSUM_KEY = "dfs.client.read.shortcircuit.skip.checksum";
            public static final boolean SKIP_CHECKSUM_DEFAULT = false;
            public static final String BUFFER_SIZE_KEY = "dfs.client.read.shortcircuit.buffer.size";
            public static final int BUFFER_SIZE_DEFAULT = 0x100000;
            public static final String STREAMS_CACHE_SIZE_KEY = "dfs.client.read.shortcircuit.streams.cache.size";
            public static final int STREAMS_CACHE_SIZE_DEFAULT = 256;
            public static final String STREAMS_CACHE_EXPIRY_MS_KEY = "dfs.client.read.shortcircuit.streams.cache.expiry.ms";
            public static final long STREAMS_CACHE_EXPIRY_MS_DEFAULT = 300000L;
            public static final String METRICS_SAMPLING_PERCENTAGE_KEY = "dfs.client.read.shortcircuit.metrics.sampling.percentage";
            public static final int METRICS_SAMPLING_PERCENTAGE_DEFAULT = 0;
        }
    }

    public static interface BlockWrite {
        public static final String PREFIX = "dfs.client.block.write.";
        public static final String RETRIES_KEY = "dfs.client.block.write.retries";
        public static final int RETRIES_DEFAULT = 3;
        public static final String LOCATEFOLLOWINGBLOCK_RETRIES_KEY = "dfs.client.block.write.locateFollowingBlock.retries";
        public static final int LOCATEFOLLOWINGBLOCK_RETRIES_DEFAULT = 5;
        public static final String LOCATEFOLLOWINGBLOCK_INITIAL_DELAY_MS_KEY = "dfs.client.block.write.locateFollowingBlock.initial.delay.ms";
        public static final int LOCATEFOLLOWINGBLOCK_INITIAL_DELAY_MS_DEFAULT = 400;

        public static interface ReplaceDatanodeOnFailure {
            public static final String PREFIX = "dfs.client.block.write.replace-datanode-on-failure.";
            public static final String ENABLE_KEY = "dfs.client.block.write.replace-datanode-on-failure.enable";
            public static final boolean ENABLE_DEFAULT = true;
            public static final String POLICY_KEY = "dfs.client.block.write.replace-datanode-on-failure.policy";
            public static final String POLICY_DEFAULT = "DEFAULT";
            public static final String BEST_EFFORT_KEY = "dfs.client.block.write.replace-datanode-on-failure.best-effort";
            public static final boolean BEST_EFFORT_DEFAULT = false;
            public static final String MIN_REPLICATION = "dfs.client.block.write.replace-datanode-on-failure.min-replication";
            public static final short MIN_REPLICATION_DEFAULT = 0;
        }
    }

    public static interface Write {
        public static final String PREFIX = "dfs.client.write.";
        public static final String MAX_PACKETS_IN_FLIGHT_KEY = "dfs.client.write.max-packets-in-flight";
        public static final int MAX_PACKETS_IN_FLIGHT_DEFAULT = 80;
        public static final String EXCLUDE_NODES_CACHE_EXPIRY_INTERVAL_KEY = "dfs.client.write.exclude.nodes.cache.expiry.interval.millis";
        public static final long EXCLUDE_NODES_CACHE_EXPIRY_INTERVAL_DEFAULT = 600000L;

        public static interface ByteArrayManager {
            public static final String PREFIX = "dfs.client.write.byte-array-manager.";
            public static final String ENABLED_KEY = "dfs.client.write.byte-array-manager.enabled";
            public static final boolean ENABLED_DEFAULT = false;
            public static final String COUNT_THRESHOLD_KEY = "dfs.client.write.byte-array-manager.count-threshold";
            public static final int COUNT_THRESHOLD_DEFAULT = 128;
            public static final String COUNT_LIMIT_KEY = "dfs.client.write.byte-array-manager.count-limit";
            public static final int COUNT_LIMIT_DEFAULT = 2048;
            public static final String COUNT_RESET_TIME_PERIOD_MS_KEY = "dfs.client.write.byte-array-manager.count-reset-time-period-ms";
            public static final long COUNT_RESET_TIME_PERIOD_MS_DEFAULT = 10000L;
        }
    }

    public static interface Failover {
        public static final String PREFIX = "dfs.client.failover.";
        public static final String PROXY_PROVIDER_KEY_PREFIX = "dfs.client.failover.proxy.provider";
        public static final String MAX_ATTEMPTS_KEY = "dfs.client.failover.max.attempts";
        public static final int MAX_ATTEMPTS_DEFAULT = 15;
        public static final String SLEEPTIME_BASE_KEY = "dfs.client.failover.sleep.base.millis";
        public static final int SLEEPTIME_BASE_DEFAULT = 500;
        public static final String SLEEPTIME_MAX_KEY = "dfs.client.failover.sleep.max.millis";
        public static final int SLEEPTIME_MAX_DEFAULT = 15000;
        public static final String CONNECTION_RETRIES_KEY = "dfs.client.failover.connection.retries";
        public static final int CONNECTION_RETRIES_DEFAULT = 0;
        public static final String CONNECTION_RETRIES_ON_SOCKET_TIMEOUTS_KEY = "dfs.client.failover.connection.retries.on.timeouts";
        public static final int CONNECTION_RETRIES_ON_SOCKET_TIMEOUTS_DEFAULT = 0;
        public static final String RANDOM_ORDER = "dfs.client.failover.random.order";
        public static final boolean RANDOM_ORDER_DEFAULT = false;
    }

    public static interface Retry {
        public static final String PREFIX = "dfs.client.retry.";
        public static final String POLICY_ENABLED_KEY = "dfs.client.retry.policy.enabled";
        public static final boolean POLICY_ENABLED_DEFAULT = false;
        public static final String POLICY_SPEC_KEY = "dfs.client.retry.policy.spec";
        public static final String POLICY_SPEC_DEFAULT = "10000,6,60000,10";
        public static final String TIMES_GET_LAST_BLOCK_LENGTH_KEY = "dfs.client.retry.times.get-last-block-length";
        public static final int TIMES_GET_LAST_BLOCK_LENGTH_DEFAULT = 3;
        public static final String INTERVAL_GET_LAST_BLOCK_LENGTH_KEY = "dfs.client.retry.interval-ms.get-last-block-length";
        public static final int INTERVAL_GET_LAST_BLOCK_LENGTH_DEFAULT = 4000;
        public static final String MAX_ATTEMPTS_KEY = "dfs.client.retry.max.attempts";
        public static final int MAX_ATTEMPTS_DEFAULT = 10;
        public static final String WINDOW_BASE_KEY = "dfs.client.retry.window.base";
        public static final int WINDOW_BASE_DEFAULT = 3000;
    }

    public static interface DeprecatedKeys {
        public static final String DFS_NAMENODE_BACKUP_ADDRESS_KEY = "dfs.namenode.backup.address";
        public static final String DFS_NAMENODE_BACKUP_HTTP_ADDRESS_KEY = "dfs.namenode.backup.http-address";
        public static final String DFS_DATANODE_BALANCE_BANDWIDTHPERSEC_KEY = "dfs.datanode.balance.bandwidthPerSec";
        public static final String DFS_DATANODE_DATA_DIR_KEY = "dfs.datanode.data.dir";
        public static final String DFS_NAMENODE_MAX_OBJECTS_KEY = "dfs.namenode.max.objects";
        public static final String DFS_NAMENODE_NAME_DIR_KEY = "dfs.namenode.name.dir";
        public static final String DFS_NAMENODE_NAME_DIR_RESTORE_KEY = "dfs.namenode.name.dir.restore";
        public static final String DFS_NAMENODE_EDITS_DIR_KEY = "dfs.namenode.edits.dir";
        public static final String DFS_NAMENODE_SAFEMODE_EXTENSION_KEY = "dfs.namenode.safemode.extension";
        public static final String DFS_NAMENODE_SAFEMODE_THRESHOLD_PCT_KEY = "dfs.namenode.safemode.threshold-pct";
        public static final String DFS_NAMENODE_SECONDARY_HTTP_ADDRESS_KEY = "dfs.namenode.secondary.http-address";
        public static final String DFS_NAMENODE_CHECKPOINT_DIR_KEY = "dfs.namenode.checkpoint.dir";
        public static final String DFS_NAMENODE_CHECKPOINT_EDITS_DIR_KEY = "dfs.namenode.checkpoint.edits.dir";
        public static final String DFS_NAMENODE_CHECKPOINT_PERIOD_KEY = "dfs.namenode.checkpoint.period";
        public static final String DFS_NAMENODE_HEARTBEAT_RECHECK_INTERVAL_KEY = "dfs.namenode.heartbeat.recheck-interval";
        public static final String DFS_CLIENT_HTTPS_KEYSTORE_RESOURCE_KEY = "dfs.client.https.keystore.resource";
        public static final String DFS_CLIENT_HTTPS_NEED_AUTH_KEY = "dfs.client.https.need-auth";
        public static final String DFS_DATANODE_HOST_NAME_KEY = "dfs.datanode.hostname";
        public static final String DFS_METRICS_SESSION_ID_KEY = "dfs.metrics.session-id";
        public static final String DFS_NAMENODE_ACCESSTIME_PRECISION_KEY = "dfs.namenode.accesstime.precision";
        public static final String DFS_NAMENODE_REDUNDANCY_CONSIDERLOAD_KEY = "dfs.namenode.redundancy.considerLoad";
        public static final String DFS_NAMENODE_REDUNDANCY_CONSIDERLOAD_FACTOR = "dfs.namenode.redundancy.considerLoad.factor";
        public static final String DFS_NAMENODE_REDUNDANCY_INTERVAL_SECONDS_KEY = "dfs.namenode.redundancy.interval.seconds";
        public static final String DFS_NAMENODE_REPLICATION_MIN_KEY = "dfs.namenode.replication.min";
        public static final String DFS_NAMENODE_RECONSTRUCTION_PENDING_TIMEOUT_SEC_KEY = "dfs.namenode.reconstruction.pending.timeout-sec";
        public static final String DFS_NAMENODE_REPLICATION_MAX_STREAMS_KEY = "dfs.namenode.replication.max-streams";
        public static final String DFS_PERMISSIONS_ENABLED_KEY = "dfs.permissions.enabled";
        public static final String DFS_PERMISSIONS_SUPERUSERGROUP_KEY = "dfs.permissions.superusergroup";
        public static final String DFS_DATANODE_MAX_RECEIVER_THREADS_KEY = "dfs.datanode.max.transfer.threads";
        public static final String DFS_NAMESERVICE_ID = "dfs.nameservice.id";
    }
}

