/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NflyFSystem;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.fs.viewfs.ViewFsLocatedFileStatus;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFileSystem
extends FileSystem {
    private static final Path ROOT_PATH = new Path("/");
    final long creationTime;
    final UserGroupInformation ugi;
    URI myUri;
    private Path workingDir;
    Configuration config;
    InodeTree<FileSystem> fsState;
    Path homeDir = null;
    private RenameStrategy renameStrategy = RenameStrategy.SAME_MOUNTPOINT;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly; operation=" + operation + "Path=" + p);
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFileSystem.readOnlyMountTable(operation, p.toString());
    }

    String getUriPath(Path p) {
        this.checkPath(p);
        return this.makeAbsolute(p).toUri().getPath();
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    public ViewFileSystem() throws IOException {
        this.ugi = UserGroupInformation.getCurrentUser();
        this.creationTime = Time.now();
    }

    @Override
    public String getScheme() {
        return "viewfs";
    }

    @Override
    public void initialize(URI theUri, Configuration conf) throws IOException {
        super.initialize(theUri, conf);
        this.setConf(conf);
        this.config = conf;
        String authority = theUri.getAuthority();
        try {
            this.myUri = new URI("viewfs", authority, "/", null, null);
            this.fsState = new InodeTree<FileSystem>(conf, authority){

                @Override
                protected FileSystem getTargetFileSystem(URI uri) throws URISyntaxException, IOException {
                    return new ChRootedFileSystem(uri, ViewFileSystem.this.config);
                }

                @Override
                protected FileSystem getTargetFileSystem(InodeTree.INodeDir<FileSystem> dir) throws URISyntaxException {
                    return new InternalDirOfViewFs(dir, ViewFileSystem.this.creationTime, ViewFileSystem.this.ugi, ViewFileSystem.this.myUri, ViewFileSystem.this.config);
                }

                @Override
                protected FileSystem getTargetFileSystem(String settings, URI[] uris) throws URISyntaxException, IOException {
                    return NflyFSystem.createFileSystem(uris, ViewFileSystem.this.config, settings);
                }
            };
            this.workingDir = this.getHomeDirectory();
            this.renameStrategy = RenameStrategy.valueOf(conf.get("fs.viewfs.rename.strategy", RenameStrategy.SAME_MOUNTPOINT.toString()));
        }
        catch (URISyntaxException e) {
            throw new IOException("URISyntax exception: " + theUri);
        }
    }

    ViewFileSystem(URI theUri, Configuration conf) throws IOException {
        this();
        this.initialize(theUri, conf);
    }

    public ViewFileSystem(Configuration conf) throws IOException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public Path resolvePath(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((FileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = base.equals("/") ? this.makeQualified(new Path(base + this.ugi.getShortUserName())) : this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.getUriPath(new_dir);
        this.workingDir = this.makeAbsolute(new_dir);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).append(res.remainingPath, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).createNonRecursive(res.remainingPath, permission, flags, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).create(res.remainingPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }
        return ((FileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public boolean delete(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(fs.getPath()), true);
        return ((FileSystem)res.targetFileSystem).getFileBlockLocations(new ViewFsFileStatus(fs, res.remainingPath), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath);
    }

    @Override
    public FileChecksum getFileChecksum(Path f, long length) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath, length);
    }

    private static FileStatus fixFileStatus(FileStatus orig, Path qualified) throws IOException {
        if ("file".equals(orig.getPath().toUri().getScheme())) {
            orig = ViewFileSystem.wrapLocalFileStatus(orig, qualified);
        }
        orig.setPath(qualified);
        return orig;
    }

    private static FileStatus wrapLocalFileStatus(FileStatus orig, Path qualified) {
        return orig instanceof LocatedFileStatus ? new ViewFsLocatedFileStatus((LocatedFileStatus)orig, qualified) : new ViewFsFileStatus(orig, qualified);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((FileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return ViewFileSystem.fixFileStatus(status, this.makeQualified(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).access(res.remainingPath, mode);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((FileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            int i = 0;
            for (FileStatus status : statusLst) {
                statusLst[i++] = ViewFileSystem.fixFileStatus(status, this.getChrootedPath(res, status, f));
            }
        }
        return statusLst;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f, PathFilter filter) throws FileNotFoundException, IOException {
        final InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        final RemoteIterator<LocatedFileStatus> statusIter = ((FileSystem)res.targetFileSystem).listLocatedStatus(res.remainingPath);
        if (res.isInternalDir()) {
            return statusIter;
        }
        return new RemoteIterator<LocatedFileStatus>(){

            @Override
            public boolean hasNext() throws IOException {
                return statusIter.hasNext();
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                LocatedFileStatus status = (LocatedFileStatus)statusIter.next();
                return (LocatedFileStatus)ViewFileSystem.fixFileStatus(status, ViewFileSystem.this.getChrootedPath(res, status, f));
            }
        };
    }

    private Path getChrootedPath(InodeTree.ResolveResult<FileSystem> res, FileStatus status, Path f) throws IOException {
        String suffix = res.targetFileSystem instanceof ChRootedFileSystem ? ((ChRootedFileSystem)res.targetFileSystem).stripOutRoot(status.getPath()) : ((NflyFSystem.NflyStatus)status).stripRoot();
        return this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix));
    }

    @Override
    public boolean mkdirs(Path dir) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath);
    }

    @Override
    public boolean mkdirs(Path dir, FsPermission permission) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath, permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        InodeTree.ResolveResult<FileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }
        InodeTree.ResolveResult<FileSystem> resDst = this.fsState.resolve(this.getUriPath(dst), false);
        if (resDst.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", dst);
        }
        URI srcUri = ((FileSystem)resSrc.targetFileSystem).getUri();
        URI dstUri = ((FileSystem)resDst.targetFileSystem).getUri();
        ViewFileSystem.verifyRenameStrategy(srcUri, dstUri, resSrc.targetFileSystem == resDst.targetFileSystem, this.renameStrategy);
        if (resSrc.targetFileSystem instanceof ChRootedFileSystem && resDst.targetFileSystem instanceof ChRootedFileSystem) {
            ChRootedFileSystem srcFS = (ChRootedFileSystem)resSrc.targetFileSystem;
            ChRootedFileSystem dstFS = (ChRootedFileSystem)resDst.targetFileSystem;
            return srcFS.getMyFs().rename(srcFS.fullPath(resSrc.remainingPath), dstFS.fullPath(resDst.remainingPath));
        }
        return ((FileSystem)resSrc.targetFileSystem).rename(resSrc.remainingPath, resDst.remainingPath);
    }

    static void verifyRenameStrategy(URI srcUri, URI dstUri, boolean isSrcDestSame, RenameStrategy renameStrategy) throws IOException {
        switch (renameStrategy) {
            case SAME_FILESYSTEM_ACROSS_MOUNTPOINT: {
                if (srcUri.getAuthority() == null || srcUri.getScheme().equals(dstUri.getScheme()) && srcUri.getAuthority().equals(dstUri.getAuthority())) break;
                throw new IOException("Renames across Mount points not supported");
            }
            case SAME_TARGET_URI_ACROSS_MOUNTPOINT: {
                if (srcUri.equals(dstUri)) break;
                throw new IOException("Renames across Mount points not supported");
            }
            case SAME_MOUNTPOINT: {
                if (isSrcDestSame) break;
                throw new IOException("Renames across Mount points not supported");
            }
            default: {
                throw new IllegalArgumentException("Unexpected rename strategy");
            }
        }
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).truncate(res.remainingPath, newLength);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).modifyAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeDefaultAcl(res.remainingPath);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAcl(res.remainingPath);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setAcl(res.remainingPath, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getAclStatus(res.remainingPath);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setXAttr(res.remainingPath, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttr(res.remainingPath, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).listXAttrs(res.remainingPath);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeXAttr(res.remainingPath, name);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setVerifyChecksum(verifyChecksum);
        }
    }

    @Override
    public long getDefaultBlockSize() {
        throw new NotInMountpointException("getDefaultBlockSize");
    }

    @Override
    public short getDefaultReplication() {
        throw new NotInMountpointException("getDefaultReplication");
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        throw new NotInMountpointException("getServerDefaults");
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultBlockSize(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }
    }

    @Override
    public short getDefaultReplication(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultReplication(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getServerDefaults(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getServerDefaults");
        }
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getContentSummary(res.remainingPath);
    }

    @Override
    public QuotaUsage getQuotaUsage(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getQuotaUsage(res.remainingPath);
    }

    @Override
    public void setWriteChecksum(boolean writeChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setWriteChecksum(writeChecksum);
        }
    }

    @Override
    public FileSystem[] getChildFileSystems() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        HashSet<FileSystem> children = new HashSet<FileSystem>();
        for (InodeTree.MountPoint<FileSystem> mountPoint : mountPoints) {
            FileSystem targetFs = (FileSystem)mountPoint.target.targetFileSystem;
            children.addAll(Arrays.asList(targetFs.getChildFileSystems()));
        }
        return children.toArray(new FileSystem[0]);
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).createSnapshot(res.remainingPath, snapshotName);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).renameSnapshot(res.remainingPath, snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).deleteSnapshot(res.remainingPath, snapshotName);
    }

    @Override
    public void setStoragePolicy(Path src, String policyName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(src), true);
        ((FileSystem)res.targetFileSystem).setStoragePolicy(res.remainingPath, policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(src), true);
        ((FileSystem)res.targetFileSystem).unsetStoragePolicy(res.remainingPath);
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(src), true);
        return ((FileSystem)res.targetFileSystem).getStoragePolicy(res.remainingPath);
    }

    @Override
    public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
        HashSet<? extends BlockStoragePolicySpi> allPolicies = new HashSet<BlockStoragePolicySpi>();
        for (FileSystem fs : this.getChildFileSystems()) {
            try {
                Collection<? extends BlockStoragePolicySpi> policies = fs.getAllStoragePolicies();
                allPolicies.addAll(policies);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return allPolicies;
    }

    @Override
    public Path getTrashRoot(Path path) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
            return ((FileSystem)res.targetFileSystem).getTrashRoot(res.remainingPath);
        }
        catch (Exception e) {
            throw new NotInMountpointException(path, "getTrashRoot");
        }
    }

    @Override
    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        ArrayList<FileStatus> trashRoots = new ArrayList<FileStatus>();
        for (FileSystem fs : this.getChildFileSystems()) {
            trashRoots.addAll(fs.getTrashRoots(allUsers));
        }
        return trashRoots;
    }

    @Override
    public FsStatus getStatus() throws IOException {
        return this.getStatus(null);
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        if (p == null) {
            p = InodeTree.SlashPath;
        }
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(p), true);
        return ((FileSystem)res.targetFileSystem).getStatus(p);
    }

    @Override
    public long getUsed() throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(InodeTree.SlashPath), true);
        if (res.isInternalDir()) {
            throw new NotInMountpointException(InodeTree.SlashPath, "getUsed");
        }
        return ((FileSystem)res.targetFileSystem).getUsed();
    }

    @Override
    public Path getLinkTarget(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(path), true);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(path, "getLinkTarget");
        }
        return ((FileSystem)res.targetFileSystem).getLinkTarget(res.remainingPath);
    }

    static enum RenameStrategy {
        SAME_MOUNTPOINT,
        SAME_TARGET_URI_ACROSS_MOUNTPOINT,
        SAME_FILESYSTEM_ACROSS_MOUNTPOINT;

    }

    static class InternalDirOfViewFs
    extends FileSystem {
        final InodeTree.INodeDir<FileSystem> theInternalDir;
        final long creationTime;
        final UserGroupInformation ugi;
        final URI myUri;

        public InternalDirOfViewFs(InodeTree.INodeDir<FileSystem> dir, long cTime, UserGroupInformation ugi, URI uri, Configuration config) throws URISyntaxException {
            this.myUri = uri;
            try {
                this.initialize(this.myUri, config);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot occur");
            }
            this.theInternalDir = dir;
            this.creationTime = cTime;
            this.ugi = ugi;
        }

        private static void checkPathIsSlash(Path f) throws IOException {
            if (f != InodeTree.SlashPath) {
                throw new IOException("Internal implementation error: expected file name to be /");
            }
        }

        @Override
        public URI getUri() {
            return this.myUri;
        }

        @Override
        public Path getWorkingDirectory() {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public void setWorkingDirectory(Path new_dir) {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("append", f);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws AccessControlException {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }

        @Override
        public boolean delete(Path f) throws AccessControlException, IOException {
            return this.delete(f, true);
        }

        @Override
        public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(fs.getPath());
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            return new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), new Path(this.theInternalDir.fullPath).makeQualified(this.myUri, ROOT_PATH));
        }

        @Override
        public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            FileStatus[] result = new FileStatus[this.theInternalDir.getChildren().size()];
            int i = 0;
            for (Map.Entry<String, InodeTree.INode<FileSystem>> iEntry : this.theInternalDir.getChildren().entrySet()) {
                InodeTree.INode<FileSystem> inode = iEntry.getValue();
                if (inode.isLink()) {
                    InodeTree.INodeLink link = (InodeTree.INodeLink)inode;
                    result[i++] = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), link.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                    continue;
                }
                result[i++] = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getGroupNames()[0], new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public boolean mkdirs(Path dir, FsPermission permission) throws AccessControlException, FileAlreadyExistsException {
            if (this.theInternalDir.isRoot() && dir == null) {
                throw new FileAlreadyExistsException("/ already exits");
            }
            if (this.theInternalDir.getChildren().containsKey(dir.toString().substring(1))) {
                return true;
            }
            throw ViewFileSystem.readOnlyMountTable("mkdirs", dir);
        }

        @Override
        public boolean mkdirs(Path dir) throws AccessControlException, FileAlreadyExistsException {
            return this.mkdirs(dir, null);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public boolean rename(Path src, Path dst) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            InternalDirOfViewFs.checkPathIsSlash(dst);
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }

        @Override
        public boolean truncate(Path f, long newLength) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("truncate", f);
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setOwner", f);
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setPermission", f);
        }

        @Override
        public boolean setReplication(Path f, short replication) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setReplication", f);
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setTimes", f);
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) {
        }

        @Override
        public FsServerDefaults getServerDefaults(Path f) throws IOException {
            throw new NotInMountpointException(f, "getServerDefaults");
        }

        @Override
        public long getDefaultBlockSize(Path f) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }

        @Override
        public short getDefaultReplication(Path f) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }

        @Override
        public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("modifyAclEntries", path);
        }

        @Override
        public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeAclEntries", path);
        }

        @Override
        public void removeDefaultAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeDefaultAcl", path);
        }

        @Override
        public void removeAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeAcl", path);
        }

        @Override
        public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("setAcl", path);
        }

        @Override
        public AclStatus getAclStatus(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            return new AclStatus.Builder().owner(this.ugi.getShortUserName()).group(this.ugi.getPrimaryGroupName()).addEntries(AclUtil.getMinimalAcl(Constants.PERMISSION_555)).stickyBit(false).build();
        }

        @Override
        public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("setXAttr", path);
        }

        @Override
        public byte[] getXAttr(Path path, String name) throws IOException {
            throw new NotInMountpointException(path, "getXAttr");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public List<String> listXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "listXAttrs");
        }

        @Override
        public void removeXAttr(Path path, String name) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeXAttr", path);
        }

        @Override
        public Path createSnapshot(Path path, String snapshotName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("createSnapshot", path);
        }

        @Override
        public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("renameSnapshot", path);
        }

        @Override
        public void deleteSnapshot(Path path, String snapshotName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("deleteSnapshot", path);
        }

        @Override
        public QuotaUsage getQuotaUsage(Path f) throws IOException {
            throw new NotInMountpointException(f, "getQuotaUsage");
        }

        @Override
        public void setStoragePolicy(Path src, String policyName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            throw ViewFileSystem.readOnlyMountTable("setStoragePolicy", src);
        }

        @Override
        public void unsetStoragePolicy(Path src) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            throw ViewFileSystem.readOnlyMountTable("unsetStoragePolicy", src);
        }

        @Override
        public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
            throw new NotInMountpointException(src, "getStoragePolicy");
        }

        @Override
        public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
            HashSet<? extends BlockStoragePolicySpi> allPolicies = new HashSet<BlockStoragePolicySpi>();
            for (FileSystem fs : this.getChildFileSystems()) {
                try {
                    Collection<? extends BlockStoragePolicySpi> policies = fs.getAllStoragePolicies();
                    allPolicies.addAll(policies);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            return allPolicies;
        }
    }

    public static class MountPoint {
        private final Path mountedOnPath;
        private final URI[] targetFileSystemURIs;

        MountPoint(Path srcPath, URI[] targetFs) {
            this.mountedOnPath = srcPath;
            this.targetFileSystemURIs = targetFs;
        }

        public Path getMountedOnPath() {
            return this.mountedOnPath;
        }

        public URI[] getTargetFileSystemURIs() {
            return this.targetFileSystemURIs;
        }
    }
}

