/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;
import org.apache.seatunnel.transform.common.ErrorHandleWay;
import org.apache.seatunnel.transform.common.SeaTunnelRowContainerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleFieldOutputTransform
extends AbstractCatalogSupportMapTransform {
    private static final Logger log = LoggerFactory.getLogger(MultipleFieldOutputTransform.class);
    private static final String[] TYPE_ARRAY_STRING = new String[0];
    private String[] outputFieldNames;
    private int[] fieldsIndex;
    private SeaTunnelRowContainerGenerator rowContainerGenerator;

    public MultipleFieldOutputTransform(@NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
    }

    public MultipleFieldOutputTransform(@NonNull CatalogTable inputCatalogTable, ErrorHandleWay errorHandleWay) {
        super(inputCatalogTable, errorHandleWay);
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object[] fieldValues = this.getOutputFieldValues(new SeaTunnelRowAccessor(inputRow));
        SeaTunnelRow outputRow = (SeaTunnelRow)this.rowContainerGenerator.apply(inputRow);
        for (int i = 0; i < this.outputFieldNames.length; ++i) {
            outputRow.setField(this.fieldsIndex[i], fieldValues == null ? null : fieldValues[i]);
        }
        return outputRow;
    }

    protected abstract Object[] getOutputFieldValues(SeaTunnelRowAccessor var1);

    @Override
    protected TableSchema transformTableSchema() {
        Column[] outputColumns = this.getOutputColumns();
        this.outputFieldNames = Arrays.stream(outputColumns).map(Column::getName).collect(Collectors.toList()).toArray(TYPE_ARRAY_STRING);
        List copiedConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().map(ConstraintKey::copy).collect(Collectors.toList());
        TableSchema.Builder builder = TableSchema.builder();
        if (this.inputCatalogTable.getTableSchema().getPrimaryKey() != null) {
            builder.primaryKey(this.inputCatalogTable.getTableSchema().getPrimaryKey().copy());
        }
        builder.constraintKey(copiedConstraintKeys);
        List columns = this.inputCatalogTable.getTableSchema().getColumns().stream().map(Column::copy).collect(Collectors.toList());
        int addFieldCount = 0;
        this.fieldsIndex = new int[outputColumns.length];
        for (int i = 0; i < outputColumns.length; ++i) {
            Column outputColumn = outputColumns[i];
            Optional<Column> optional = columns.stream().filter(c -> c.getName().equals(outputColumn.getName())).findFirst();
            if (optional.isPresent()) {
                Column originalColumn = optional.get();
                int originalColumnIndex = columns.indexOf(originalColumn);
                if (!originalColumn.getDataType().equals(outputColumn.getDataType())) {
                    columns.set(originalColumnIndex, originalColumn.copy(outputColumn.getDataType()));
                }
                this.fieldsIndex[i] = originalColumnIndex;
                continue;
            }
            ++addFieldCount;
            columns.add(outputColumn);
            this.fieldsIndex[i] = columns.indexOf(outputColumn);
        }
        TableSchema outputTableSchema = builder.columns(columns).build();
        if (addFieldCount > 0) {
            final int inputFieldLength = this.inputCatalogTable.getTableSchema().toPhysicalRowDataType().getTotalFields();
            final int outputFieldLength = columns.size();
            this.rowContainerGenerator = new SeaTunnelRowContainerGenerator(){

                @Override
                public SeaTunnelRow apply(SeaTunnelRow inputRow) {
                    Object[] outputFieldValues = new Object[outputFieldLength];
                    System.arraycopy(inputRow.getFields(), 0, outputFieldValues, 0, inputFieldLength);
                    SeaTunnelRow outputRow = new SeaTunnelRow(outputFieldValues);
                    outputRow.setTableId(inputRow.getTableId());
                    outputRow.setRowKind(inputRow.getRowKind());
                    return outputRow;
                }
            };
        } else {
            this.rowContainerGenerator = SeaTunnelRowContainerGenerator.REUSE_ROW;
        }
        log.info("Changed input table schema: {} to output table schema: {}", (Object)this.inputCatalogTable.getTableSchema(), (Object)outputTableSchema);
        return outputTableSchema;
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }

    protected abstract Column[] getOutputColumns();
}

