/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.exception;

import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformCommonErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;

public class TransformCommonError {
    public static TransformException cannotFindInputFieldError(String transform, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("field", field);
        params.put("transform", transform);
        return new TransformException((SeaTunnelErrorCode)TransformCommonErrorCode.INPUT_FIELD_NOT_FOUND, params);
    }

    public static TransformException cannotFindInputFieldsError(String transform, List<String> fields) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fields", String.join((CharSequence)",", fields));
        params.put("transform", transform);
        return new TransformException((SeaTunnelErrorCode)TransformCommonErrorCode.INPUT_FIELDS_NOT_FOUND, params);
    }

    public static TransformException cannotFindMetadataFieldError(String transform, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("field", field);
        params.put("transform", transform);
        return new TransformException((SeaTunnelErrorCode)TransformCommonErrorCode.METADATA_FIELDS_NOT_FOUND, params);
    }

    public static TransformException metadataMappingFieldExists(String transform, String field) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("field", field);
        params.put("transform", transform);
        return new TransformException((SeaTunnelErrorCode)TransformCommonErrorCode.METADATA_MAPPING_FIELD_EXISTS, params);
    }

    public static TransformException cannotFindInputTableError(String transform, String table) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("table", table);
        params.put("transform", transform);
        return new TransformException((SeaTunnelErrorCode)TransformCommonErrorCode.INPUT_TABLE_NOT_FOUND, params);
    }
}

