/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.rename;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;
import org.apache.seatunnel.transform.rename.TableRenameConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRenameTransform
extends AbstractCatalogSupportMapTransform {
    private static final Logger log = LoggerFactory.getLogger(TableRenameTransform.class);
    public static String PLUGIN_NAME = "TableRename";
    private final CatalogTable inputTable;
    private final TableRenameConfig config;
    private TablePath outputTablePath;
    private String outputTableId;

    public TableRenameTransform(TableRenameConfig config, CatalogTable table) {
        super(table);
        this.inputTable = table;
        this.config = config;
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected TableSchema transformTableSchema() {
        return TableSchema.builder().columns(this.inputTable.getTableSchema().getColumns()).constraintKey(this.inputTable.getTableSchema().getConstraintKeys()).primaryKey(this.inputTable.getTableSchema().getPrimaryKey()).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        TablePath outputTablePath;
        TablePath inputTablePath = this.inputTable.getTablePath();
        String inputDatabaseName = inputTablePath.getDatabaseName();
        String inputSchemaName = inputTablePath.getSchemaName();
        String inputTableName = inputTablePath.getTableName();
        String outputDatabaseName = Optional.ofNullable(inputDatabaseName).map(this::convertCase).orElse(null);
        String outputSchemaName = Optional.ofNullable(inputSchemaName).map(this::convertCase).orElse(null);
        String outputTableName = this.convertName(inputTableName);
        this.outputTablePath = outputTablePath = TablePath.of((String)outputDatabaseName, (String)outputSchemaName, (String)outputTableName);
        this.outputTableId = outputTablePath.getFullName();
        return TableIdentifier.of((String)this.inputTable.getCatalogName(), (TablePath)outputTablePath);
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        if (inputRow.getTableId() == null) {
            log.debug("Table id is null, skip renaming");
            return inputRow;
        }
        if (this.outputTableId.equals(inputRow.getTableId())) {
            return inputRow;
        }
        SeaTunnelRow outputRow = inputRow.copy();
        outputRow.setTableId(this.outputTableId);
        return outputRow;
    }

    public SchemaChangeEvent mapSchemaChangeEvent(SchemaChangeEvent event) {
        TablePath inputTablePath = event.tablePath();
        if (inputTablePath == null) {
            return event;
        }
        if (this.outputTablePath.equals((Object)inputTablePath)) {
            return event;
        }
        if (event instanceof AlterTableColumnsEvent) {
            TableIdentifier newTableIdentifier = TableIdentifier.of((String)event.tableIdentifier().getCatalogName(), (TablePath)this.outputTablePath);
            AlterTableColumnsEvent alterTableColumnsEvent = (AlterTableColumnsEvent)event;
            AlterTableColumnsEvent newEvent = new AlterTableColumnsEvent(newTableIdentifier, alterTableColumnsEvent.getEvents().stream().map(this::convertName).collect(Collectors.toList()));
            newEvent.setJobId(event.getJobId());
            newEvent.setStatement(((AlterTableColumnsEvent)event).getStatement());
            newEvent.setSourceDialectName(((AlterTableColumnsEvent)event).getSourceDialectName());
            if (event.getChangeAfter() != null) {
                newEvent.setChangeAfter(CatalogTable.of((TableIdentifier)newTableIdentifier, (CatalogTable)event.getChangeAfter()));
            }
            return newEvent;
        }
        if (event instanceof AlterTableColumnEvent) {
            return this.convertName((AlterTableColumnEvent)event);
        }
        return event;
    }

    public String convertCase(String name) {
        if (this.config.getConvertCase() != null) {
            switch (this.config.getConvertCase()) {
                case UPPER: {
                    return name.toUpperCase();
                }
                case LOWER: {
                    return name.toLowerCase();
                }
            }
            throw new UnsupportedOperationException("Unsupported convert case: " + (Object)((Object)this.config.getConvertCase()));
        }
        return name;
    }

    @VisibleForTesting
    public String convertName(String tableName) {
        String replaceTo = null;
        LinkedHashMap replaceIndex = new LinkedHashMap();
        if (CollectionUtils.isNotEmpty(this.config.getReplacementsWithRegex())) {
            for (TableRenameConfig.ReplacementsWithRegex replacementsWithRegex : this.config.getReplacementsWithRegex()) {
                Boolean isRegex = replacementsWithRegex.getIsRegex();
                String replacement = replacementsWithRegex.getReplaceFrom();
                if (!StringUtils.isNotEmpty((CharSequence)replacement)) continue;
                LinkedHashMap<Integer, Integer> matched = new LinkedHashMap<Integer, Integer>();
                if (BooleanUtils.isNotTrue((Boolean)isRegex)) {
                    if (StringUtils.equals((CharSequence)replacement, (CharSequence)tableName)) {
                        matched.put(0, tableName.length());
                    }
                } else {
                    Matcher matcher = Pattern.compile(replacement).matcher(tableName);
                    while (matcher.find()) {
                        matched.put(matcher.start(), matcher.end());
                    }
                }
                if (matched.isEmpty()) continue;
                replaceTo = replacementsWithRegex.getReplaceTo();
                replaceIndex = matched;
            }
        }
        tableName = this.convertCase(tableName);
        int offset = 0;
        for (Map.Entry index : replaceIndex.entrySet()) {
            int indexStart = (Integer)index.getKey();
            int indexEnd = (Integer)index.getValue();
            tableName = tableName.substring(0, indexStart + offset) + replaceTo.trim() + tableName.substring(indexEnd + offset);
            offset += replaceTo.trim().length() - (indexEnd - indexStart);
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getPrefix())) {
            tableName = this.config.getPrefix().trim() + tableName;
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getSuffix())) {
            tableName = tableName + this.config.getSuffix().trim();
        }
        return tableName;
    }

    @VisibleForTesting
    public AlterTableColumnEvent convertName(AlterTableColumnEvent event) {
        TableIdentifier newTableIdentifier = TableIdentifier.of((String)event.tableIdentifier().getCatalogName(), (TablePath)this.outputTablePath);
        AlterTableColumnEvent newEvent = event;
        switch (event.getEventType()) {
            case SCHEMA_CHANGE_ADD_COLUMN: {
                AlterTableAddColumnEvent addColumnEvent = (AlterTableAddColumnEvent)event;
                newEvent = new AlterTableAddColumnEvent(newTableIdentifier, addColumnEvent.getColumn(), addColumnEvent.isFirst(), addColumnEvent.getAfterColumn());
                break;
            }
            case SCHEMA_CHANGE_DROP_COLUMN: {
                AlterTableDropColumnEvent dropColumnEvent = (AlterTableDropColumnEvent)event;
                newEvent = new AlterTableDropColumnEvent(newTableIdentifier, dropColumnEvent.getColumn());
                break;
            }
            case SCHEMA_CHANGE_MODIFY_COLUMN: {
                AlterTableModifyColumnEvent modifyColumnEvent = (AlterTableModifyColumnEvent)event;
                newEvent = new AlterTableModifyColumnEvent(newTableIdentifier, modifyColumnEvent.getColumn(), modifyColumnEvent.isFirst(), modifyColumnEvent.getAfterColumn());
                break;
            }
            case SCHEMA_CHANGE_CHANGE_COLUMN: {
                AlterTableChangeColumnEvent changeColumnEvent = (AlterTableChangeColumnEvent)event;
                newEvent = new AlterTableChangeColumnEvent(newTableIdentifier, changeColumnEvent.getOldColumn(), changeColumnEvent.getColumn(), changeColumnEvent.isFirst(), changeColumnEvent.getAfterColumn());
                break;
            }
            default: {
                log.warn("Unsupported event: {}", (Object)event);
                return event;
            }
        }
        newEvent.setJobId(event.getJobId());
        newEvent.setStatement(event.getStatement());
        newEvent.setSourceDialectName(event.getSourceDialectName());
        if (event.getChangeAfter() != null) {
            newEvent.setChangeAfter(CatalogTable.of((TableIdentifier)newTableIdentifier, (CatalogTable)event.getChangeAfter()));
        }
        return newEvent;
    }
}

