/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.rowkind;

import java.util.Arrays;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowAccessor;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.transform.common.SingleFieldOutputTransform;
import org.apache.seatunnel.transform.rowkind.RowKindExtractorTransformConfig;
import org.apache.seatunnel.transform.rowkind.RowKindExtractorTransformType;

public class RowKindExtractorTransform
extends SingleFieldOutputTransform {
    private final ReadonlyConfig config;
    private final RowKindExtractorTransformType transformType;

    public RowKindExtractorTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.config = config;
        this.transformType = (RowKindExtractorTransformType)((Object)config.get(RowKindExtractorTransformConfig.TRANSFORM_TYPE));
    }

    public String getPluginName() {
        return "RowKindExtractor";
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object fieldValue = this.getOutputFieldValue(new SeaTunnelRowAccessor(inputRow));
        inputRow.setRowKind(RowKind.INSERT);
        SeaTunnelRow outputRow = (SeaTunnelRow)this.getRowContainerGenerator().apply(inputRow);
        outputRow.setField(this.getFieldIndex(), fieldValue);
        return outputRow;
    }

    @Override
    protected Object getOutputFieldValue(SeaTunnelRowAccessor inputRow) {
        switch (this.transformType) {
            case SHORT: {
                return inputRow.getRowKind().shortString();
            }
            case FULL: {
                return inputRow.getRowKind().name();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported transform type %s", new Object[]{this.transformType}));
    }

    @Override
    protected Column getOutputColumn() {
        String customFieldName = (String)this.config.get(RowKindExtractorTransformConfig.CUSTOM_FIELD_NAME);
        String[] fieldNames = this.inputCatalogTable.getTableSchema().getFieldNames();
        boolean isExist = Arrays.asList(fieldNames).contains(customFieldName);
        if (isExist) {
            throw new IllegalArgumentException(String.format("field name %s already exists", customFieldName));
        }
        return PhysicalColumn.of((String)customFieldName, (SeaTunnelDataType)BasicType.STRING_TYPE, (Long)13L, (boolean)false, (Object)RowKind.INSERT.shortString(), (String)"Output column of RowKind");
    }

    @VisibleForTesting
    public void initRowContainerGenerator() {
        this.transformTableSchema();
    }
}

