/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.table;

import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class TableFilterConfig
implements Serializable {
    public static final String PLUGIN_NAME = "TableFilter";
    public static final Option<String> DATABASE_PATTERN = Options.key((String)"database_pattern").stringType().noDefaultValue().withDescription("Specify database filter patternThe default value is null, which means no filtering. If you want to filter the database name, please set it to a regular expression.");
    public static final Option<String> SCHEMA_PATTERN = Options.key((String)"schema_pattern").stringType().noDefaultValue().withDescription("Specify schema filter patternThe default value is null, which means no filtering. If you want to filter the schema name, please set it to a regular expression.");
    public static final Option<String> TABLE_PATTERN = Options.key((String)"table_pattern").stringType().noDefaultValue().withDescription("Specify table filter patternThe default value is null, which means no filtering. If you want to filter the table name, please set it to a regular expression.");
    public static final Option<PatternMode> PATTERN_MODE = Options.key((String)"pattern_mode").enumType(PatternMode.class).defaultValue((Object)PatternMode.INCLUDE).withDescription("Specify pattern modeThe default value is INCLUDE, which means include the matched table.If you want to exclude the matched table, please set it to EXCLUDE.");
    @JsonAlias(value={"database_pattern"})
    private String databasePattern;
    @JsonAlias(value={"schema_pattern"})
    private String schemaPattern;
    @JsonAlias(value={"table_pattern"})
    private String tablePattern;
    @JsonAlias(value={"pattern_mode"})
    private PatternMode patternMode;

    public boolean isMatch(TablePath tablePath) {
        if (PatternMode.INCLUDE.equals((Object)this.patternMode)) {
            if (this.databasePattern != null && !tablePath.getDatabaseName().matches(this.databasePattern)) {
                return false;
            }
            if (this.schemaPattern != null && !tablePath.getSchemaName().matches(this.schemaPattern)) {
                return false;
            }
            return this.tablePattern == null || tablePath.getTableName().matches(this.tablePattern);
        }
        if (this.databasePattern != null && tablePath.getDatabaseName().matches(this.databasePattern)) {
            return false;
        }
        if (this.schemaPattern != null && tablePath.getSchemaName().matches(this.schemaPattern)) {
            return false;
        }
        return this.tablePattern == null || !tablePath.getTableName().matches(this.tablePattern);
    }

    public static TableFilterConfig of(ReadonlyConfig config) {
        TableFilterConfig filterConfig = new TableFilterConfig();
        filterConfig.setDatabasePattern((String)config.get(DATABASE_PATTERN));
        filterConfig.setSchemaPattern((String)config.get(SCHEMA_PATTERN));
        filterConfig.setTablePattern((String)config.get(TABLE_PATTERN));
        filterConfig.setPatternMode((PatternMode)((Object)config.get(PATTERN_MODE)));
        Preconditions.checkArgument((filterConfig.getDatabasePattern() != null || filterConfig.getSchemaPattern() != null || filterConfig.getTablePattern() != null || filterConfig.getPatternMode() != null ? 1 : 0) != 0, (Object)"At least one of database_pattern, schema_pattern, table_pattern or pattern_mode must be specified.");
        return filterConfig;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public PatternMode getPatternMode() {
        return this.patternMode;
    }

    public TableFilterConfig setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
        return this;
    }

    public TableFilterConfig setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
        return this;
    }

    public TableFilterConfig setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
        return this;
    }

    public TableFilterConfig setPatternMode(PatternMode patternMode) {
        this.patternMode = patternMode;
        return this;
    }

    public String toString() {
        return "TableFilterConfig(databasePattern=" + this.getDatabasePattern() + ", schemaPattern=" + this.getSchemaPattern() + ", tablePattern=" + this.getTablePattern() + ", patternMode=" + (Object)((Object)this.getPatternMode()) + ")";
    }

    public static enum PatternMode {
        INCLUDE,
        EXCLUDE;

    }
}

