/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import com.google.common.collect.ImmutableList;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public class UnidataPointDatasetHelper {
    public static CalendarDate getStartDate(NetcdfDataset ds, CalendarDateUnit timeUnit) {
        return UnidataPointDatasetHelper.getDate(ds, timeUnit, "time_coverage_start");
    }

    public static CalendarDate getEndDate(NetcdfDataset ds, CalendarDateUnit timeUnit) {
        return UnidataPointDatasetHelper.getDate(ds, timeUnit, "time_coverage_end");
    }

    private static CalendarDate getDate(NetcdfDataset ds, CalendarDateUnit timeUnit, String attName) {
        CalendarDate result;
        Attribute att = ds.findGlobalAttributeIgnoreCase(attName);
        if (null == att) {
            throw new IllegalArgumentException("Must have a global attribute named " + attName);
        }
        if (att.getDataType() == DataType.STRING) {
            result = CalendarDate.parseUdunitsOrIso(null, att.getStringValue());
            if (result == null && timeUnit != null) {
                double val = Double.parseDouble(att.getStringValue());
                result = timeUnit.makeCalendarDate(val);
            }
        } else if (timeUnit != null) {
            double val = att.getNumericValue().doubleValue();
            result = timeUnit.makeCalendarDate(val);
        } else {
            throw new IllegalArgumentException(attName + " must be a ISO or udunit date string");
        }
        return result;
    }

    public static LatLonRect getBoundingBox(NetcdfDataset ds) {
        double lat_max = UnidataPointDatasetHelper.getAttAsDouble(ds, "geospatial_lat_max");
        double lat_min = UnidataPointDatasetHelper.getAttAsDouble(ds, "geospatial_lat_min");
        double lon_max = UnidataPointDatasetHelper.getAttAsDouble(ds, "geospatial_lon_max");
        double lon_min = UnidataPointDatasetHelper.getAttAsDouble(ds, "geospatial_lon_min");
        return new LatLonRect(LatLonPoint.create(lat_min, lon_min), lat_max - lat_min, lon_max - lon_min);
    }

    private static double getAttAsDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (null == att) {
            throw new IllegalArgumentException("Must have a " + attname + " global attribute");
        }
        if (att.getDataType() == DataType.STRING) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    public static String getCoordinateName(NetcdfDataset ds, AxisType a) {
        ImmutableList<Variable> varList = ds.getVariables();
        for (Variable v : varList) {
            if (v instanceof Structure) {
                ImmutableList<Variable> vars = ((Structure)v).getVariables();
                for (Variable vs : vars) {
                    String axisType = vs.findAttributeString("_CoordinateAxisType", null);
                    if (axisType == null || !axisType.equals(a.toString())) continue;
                    return vs.getShortName();
                }
                continue;
            }
            String axisType = v.findAttributeString("_CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return v.getShortName();
        }
        if (a == AxisType.Lat) {
            return UnidataPointDatasetHelper.findVariableName(ds, "latitude");
        }
        if (a == AxisType.Lon) {
            return UnidataPointDatasetHelper.findVariableName(ds, "longitude");
        }
        if (a == AxisType.Time) {
            return UnidataPointDatasetHelper.findVariableName(ds, "time");
        }
        if (a == AxisType.Height) {
            Variable v = UnidataPointDatasetHelper.findVariable(ds, "altitude");
            if (null == v) {
                v = UnidataPointDatasetHelper.findVariable(ds, "depth");
            }
            if (v != null) {
                return v.getShortName();
            }
        }
        return null;
    }

    public static String getCoordinateName(NetcdfDataset ds, AxisType a, Dimension dim) {
        String name = UnidataPointDatasetHelper.getCoordinateName(ds, a);
        if (name == null) {
            return null;
        }
        Variable v = ds.findVariable(name);
        if (v == null) {
            return null;
        }
        if (v.isScalar()) {
            return null;
        }
        if (!v.getDimension(0).equals(dim)) {
            return null;
        }
        return name;
    }

    public static Variable getCoordinate(NetcdfDataset ds, AxisType a) {
        ImmutableList<Variable> varList = ds.getVariables();
        for (Variable v : varList) {
            if (v instanceof Structure) {
                ImmutableList<Variable> vars = ((Structure)v).getVariables();
                for (Variable vs : vars) {
                    String axisType = vs.findAttributeString("_CoordinateAxisType", null);
                    if (axisType == null || !axisType.equals(a.toString())) continue;
                    return vs;
                }
                continue;
            }
            String axisType = v.findAttributeString("_CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return v;
        }
        if (a == AxisType.Lat) {
            return UnidataPointDatasetHelper.findVariable(ds, "latitude");
        }
        if (a == AxisType.Lon) {
            return UnidataPointDatasetHelper.findVariable(ds, "longitude");
        }
        if (a == AxisType.Time) {
            return UnidataPointDatasetHelper.findVariable(ds, "time");
        }
        if (a == AxisType.Height) {
            Variable v = UnidataPointDatasetHelper.findVariable(ds, "altitude");
            if (null == v) {
                v = UnidataPointDatasetHelper.findVariable(ds, "depth");
            }
            return v;
        }
        return null;
    }

    public static String findVariableName(NetcdfFile ds, String name) {
        Variable result = UnidataPointDatasetHelper.findVariable(ds, name);
        return result == null ? null : result.getShortName();
    }

    public static Variable findVariable(NetcdfFile ds, String name) {
        Variable result = ds.findVariable(name);
        if (result == null) {
            String aname = ds.getRootGroup().findAttributeString(name + "_coordinate", null);
            if (aname != null) {
                result = ds.findVariable(aname);
            } else {
                aname = ds.getRootGroup().findAttributeString(name + "_variable", null);
                if (aname != null) {
                    result = ds.findVariable(aname);
                }
            }
        }
        return result;
    }

    public static Dimension findDimension(NetcdfFile ds, String name) {
        String aname;
        Dimension result = ds.findDimension(name);
        if (result == null && (aname = ds.getRootGroup().findAttributeString(name + "Dimension", null)) != null) {
            result = ds.findDimension(aname);
        }
        return result;
    }

    public static Dimension findObsDimension(NetcdfFile ds) {
        Dimension result = null;
        String aname = ds.getRootGroup().findAttributeString("observationDimension", null);
        if (aname != null) {
            result = ds.findDimension(aname);
        }
        if (result == null) {
            result = ds.getUnlimitedDimension();
        }
        return result;
    }
}

