/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.shaded.s2.S2Polygon;

public class MultiPolygonGeography
extends GeographyCollection {
    private static final Logger logger = Logger.getLogger(MultiPolygonGeography.class.getName());

    public MultiPolygonGeography(Geography.GeographyKind kind, List<S2Polygon> polygons) {
        super(kind, polygons);
    }

    public MultiPolygonGeography() {
        super(Collections.emptyList());
    }

    @Override
    public List<Geography> getFeatures() {
        return this.features;
    }

    @Override
    public int dimension() {
        return 2;
    }

    @Override
    public void encode(UnsafeOutput out, EncodeOptions opts) throws IOException {
        out.writeInt(this.features.size());
        for (Geography feature : this.features) {
            ((PolygonGeography)feature).polygon.encode((OutputStream)out);
        }
        out.flush();
    }

    public static MultiPolygonGeography decode(Input in, EncodeTag tag) throws IOException {
        if (!(in instanceof UnsafeInput)) {
            throw new IllegalArgumentException("Expected UnsafeInput");
        }
        return MultiPolygonGeography.decode((UnsafeInput)in, tag);
    }

    public static MultiPolygonGeography decode(UnsafeInput in, EncodeTag tag) throws IOException, EOFException {
        MultiPolygonGeography geo;
        if ((tag.getFlags() & 1) != 0) {
            logger.fine("Decoded empty Multipolygon.");
            return new MultiPolygonGeography();
        }
        tag.skipCovering(in);
        try {
            int count = in.readInt();
            if (count < 0) {
                throw new IOException("MultiPolygon.decodeTagged error: negative polygon count: " + count);
            }
            ArrayList<S2Polygon> polygons = new ArrayList<S2Polygon>();
            for (int i = 0; i < count; ++i) {
                polygons.add(S2Polygon.decode((InputStream)in));
            }
            geo = new MultiPolygonGeography(Geography.GeographyKind.MULTIPOLYGON, polygons);
            geo.countShapes();
        }
        catch (EOFException e) {
            throw new IOException("MultiPolygon.decodeTagged error: insufficient data to decode all parts of the geography.", e);
        }
        return geo;
    }
}

