/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;
import org.twak.camp.Edge;

public class EdgeSpatialIndex {
    private final RTree<Edge> tree = RTree.createRStar(2);
    private final int size;

    public EdgeSpatialIndex(Collection<Edge> edges) {
        this.size = edges.size();
        RTreeEntry[] boxes = new RTreeEntry[this.size];
        int i = 0;
        for (Edge e : edges) {
            double[] bb = e.getBBox();
            RTreeEntry<Edge> box = RTreeEntry.createBox(new double[]{bb[0], bb[1]}, new double[]{bb[2], bb[3]}, e);
            boxes[i++] = box;
        }
        this.tree.load(boxes);
    }

    public List<Edge> search(double minX, double minY, double maxX, double maxY) {
        double[] min2 = new double[]{minX, minY};
        double[] max = new double[]{maxX, maxY};
        ArrayList<Edge> out = new ArrayList<Edge>();
        this.tree.queryIntersect(min2, max).forEachRemaining(e -> out.add((Edge)e.value()));
        return out;
    }

    public List<Edge> search(double cX, double cY, int k) {
        double[] center = new double[]{cX, cY};
        ArrayList<Edge> out = new ArrayList<Edge>();
        if (k >= this.size) {
            this.tree.iterator().forEachRemaining(e -> out.add((Edge)e.value()));
        } else {
            this.tree.queryKnn(center, k).forEachRemaining(e -> out.add((Edge)e.value()));
        }
        return out;
    }
}

