/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.provider.pojo.InvocationCaller;
import org.apache.servicecomb.provider.pojo.PojoConsumerMetaRefresher;
import org.apache.servicecomb.provider.pojo.PojoInvocation;
import org.apache.servicecomb.provider.pojo.PojoInvocationCreator;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;

public class FilterInvocationCaller
implements InvocationCaller {
    @Override
    public Object call(Method method, PojoConsumerMetaRefresher metaRefresher, PojoInvocationCreator invocationCreator, Object[] args) {
        if (InvokerUtils.isAsyncMethod((Method)method)) {
            CompletableFuture<PojoInvocation> invocationFuture = invocationCreator.createAsync(method, metaRefresher, args);
            return invocationFuture.thenCompose(this::doCall);
        }
        PojoInvocation invocation = invocationCreator.create(method, metaRefresher, args);
        CompletionStage future = CompletableFuture.completedFuture(invocation).thenCompose(this::doCall);
        return InvokerUtils.toSync((CompletableFuture)future, (long)invocation.getWaitTime());
    }

    protected CompletableFuture<Object> doCall(PojoInvocation invocation) {
        return InvokerUtils.invoke((Invocation)invocation).thenApply(response -> {
            if (response.isSucceed()) {
                return invocation.convertResponse((Response)response);
            }
            throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
        });
    }
}

