/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.eventbus.EventBus;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.registry.lightweight.DiscoveryClient;
import org.apache.servicecomb.registry.lightweight.RegisterException;
import org.apache.servicecomb.registry.lightweight.RegisterInstanceEvent;
import org.apache.servicecomb.registry.lightweight.RegisterRequest;
import org.apache.servicecomb.registry.lightweight.Self;
import org.apache.servicecomb.registry.lightweight.UnregisterRequest;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.store.InstanceStore;
import org.apache.servicecomb.registry.lightweight.store.MicroserviceStore;
import org.apache.servicecomb.registry.lightweight.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreService.class);
    private final EventBus eventBus;
    private final Store store;
    private final DiscoveryClient discoveryClient;

    public StoreService(EventBus eventBus, Store store, DiscoveryClient discoveryClient) {
        this.store = store;
        this.discoveryClient = discoveryClient;
        this.eventBus = eventBus;
    }

    public void registerSelf(Self self) {
        MicroserviceStore microserviceStore = this.store.addMicroservice(self.getMicroservice());
        this.addInstance(microserviceStore, self.getInstance());
    }

    public InstanceStore register(RegisterRequest request) {
        return (InstanceStore)AsyncUtils.toSync(this.registerAsync(request));
    }

    public CompletableFuture<InstanceStore> registerAsync(RegisterRequest request) {
        return this.doRegisterAsync(request).whenComplete((r, e) -> this.logFailedRegister(request, (Throwable)e));
    }

    private void logFailedRegister(RegisterRequest request, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        LOGGER.error("register instance failed, serviceId={}, instanceId={}, endpoints={}.", new Object[]{request.getServiceId(), request.getInstanceId(), request.getEndpoints(), throwable});
    }

    private CompletableFuture<InstanceStore> doRegisterAsync(RegisterRequest request) {
        InstanceStore instanceStore = this.store.findInstanceStore(request.getInstanceId());
        if (instanceStore == null) {
            return this.addInstance(request);
        }
        if (instanceStore.isStatusChanged(request.getStatus())) {
            this.updateInstanceStatus(request, instanceStore);
        }
        return this.heartbeat(instanceStore);
    }

    private CompletableFuture<InstanceStore> addInstance(RegisterRequest request) {
        Endpoint endpoint = request.selectFirstEndpoint();
        if (endpoint == null) {
            return AsyncUtils.completeExceptionally((Throwable)new RegisterException("can not select endpoint"));
        }
        MicroserviceStore microserviceStore = this.store.findMicroserviceStore(request.getServiceId());
        if (microserviceStore == null) {
            return this.addMicroserviceAndInstance(endpoint, request);
        }
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(v -> this.discoveryClient.getInstanceAsync(endpoint, request.getServiceId()))).thenApply(instance -> this.addInstance(microserviceStore, (MicroserviceInstance)instance));
    }

    private CompletableFuture<InstanceStore> addMicroserviceAndInstance(Endpoint endpoint, RegisterRequest request) {
        return this.discoveryClient.getInfoAsync(endpoint, request.getServiceId()).thenApply(info -> {
            info.getMicroservice().getSchemaMap().putAll(info.getSchemasById());
            MicroserviceStore microserviceStore = this.store.addMicroservice(info.getMicroservice());
            LOGGER.info("add microservice and instance, serviceId={}, instanceId={}, endpoints={}", new Object[]{request.getServiceId(), request.getInstanceId(), request.getEndpoints()});
            return this.doAddInstance(microserviceStore, info.getInstance());
        });
    }

    private InstanceStore addInstance(MicroserviceStore microserviceStore, MicroserviceInstance instance) {
        LOGGER.info("add instance, serviceId={}, instanceId={}, endpoints={}", new Object[]{instance.getServiceId(), instance.getInstanceId(), instance.getEndpoints()});
        return this.doAddInstance(microserviceStore, instance);
    }

    private InstanceStore doAddInstance(MicroserviceStore microserviceStore, MicroserviceInstance instance) {
        InstanceStore instanceStore = this.store.addInstance(microserviceStore, instance);
        this.eventBus.post((Object)new RegisterInstanceEvent(microserviceStore.getMicroservice(), instance));
        return instanceStore;
    }

    private void updateInstanceStatus(RegisterRequest request, InstanceStore instanceStore) {
        LOGGER.info("update instance status, old status={}, new status={}, serviceId={}, instanceId={}, endpoints={}", new Object[]{instanceStore.getStatus(), request.getStatus(), instanceStore.getServiceId(), instanceStore.getInstanceId(), instanceStore.getEndpoints()});
        this.store.findMicroserviceStore(instanceStore.getServiceId()).updateInstanceStatus(instanceStore, request.getStatus());
    }

    private CompletableFuture<InstanceStore> heartbeat(InstanceStore instanceStore) {
        instanceStore.updateLastHeartBeat();
        LOGGER.debug("instance heartbeat, serviceId={}, instanceId={}, endpoints={}", new Object[]{instanceStore.getServiceId(), instanceStore.getInstanceId(), instanceStore.getEndpoints()});
        return CompletableFuture.completedFuture(instanceStore);
    }

    public Void unregister(UnregisterRequest request) {
        return (Void)AsyncUtils.toSync(this.unregisterAsync(request));
    }

    public CompletableFuture<Void> unregisterAsync(UnregisterRequest request) {
        this.deleteInstance("unregister", request.getServiceId(), request.getInstanceId());
        return CompletableFuture.completedFuture(null);
    }

    public void deleteInstance(String action, String serviceId, String instanceId) {
        InstanceStore instanceStore = this.store.deleteInstance(serviceId, instanceId);
        if (instanceStore == null) {
            return;
        }
        LOGGER.info("{} instance, serviceId={}, instanceId={}, endpoints={}", new Object[]{action, instanceStore.getServiceId(), instanceStore.getInstanceId(), instanceStore.getEndpoints()});
    }

    public void deleteDeadInstances(Duration timeout) {
        this.store.findDeadInstances(timeout).forEach(instance -> this.deleteInstance("delete dead", instance.getServiceId(), instance.getInstanceId()));
    }
}

