/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.reference.ReferenceCountedResource;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.factory.RestClientFactory;

public class ReferenceCountedClient<T extends RestClient>
extends ReferenceCountedResource {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReferenceCountedClient.class);
    private ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> clients;
    private URL url;
    private RestClientFactory clientFactory;
    private T client;

    public ReferenceCountedClient(T client, ConcurrentMap<String, ReferenceCountedClient<? extends RestClient>> clients, RestClientFactory clientFactory, URL url) {
        this.client = client;
        this.clients = clients;
        this.clientFactory = clientFactory;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T getClient() {
        ReferenceCountedClient referenceCountedClient = this;
        synchronized (referenceCountedClient) {
            ReferenceCountedClient referenceCountedClient2 = (ReferenceCountedClient)this.clients.get(this.url.getAddress());
            if (!referenceCountedClient2.isDestroyed()) return this.client;
            ReferenceCountedClient referenceCountedClient3 = this;
            synchronized (referenceCountedClient3) {
                referenceCountedClient2 = (ReferenceCountedClient)this.clients.get(this.url.getAddress());
                if (referenceCountedClient2.isDestroyed()) {
                    RestClient restClient = this.clientFactory.createRestClient(this.url);
                    this.clients.put(this.url.getAddress(), new ReferenceCountedClient<RestClient>(restClient, this.clients, this.clientFactory, this.url));
                    return (T)restClient;
                }
                return referenceCountedClient2.client;
            }
        }
    }

    public boolean isDestroyed() {
        return this.client.isClosed();
    }

    @Override
    protected void destroy() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            logger.error("4-7", "", "", "Close resteasy client error", e);
        }
    }
}

