/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

abstract class AbstractHttpHeadersJsonDeserializer<T extends HttpHeaders>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 6308506823069217145L;

    AbstractHttpHeadersJsonDeserializer(Class<T> type) {
        super(type);
    }

    @Override
    @Nullable
    public final T deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode tree = (JsonNode)p.getCodec().readTree(p);
        if (!tree.isObject()) {
            ctx.reportInputMismatch(HttpHeaders.class, "HTTP headers must be an object.", new Object[0]);
            return null;
        }
        ObjectNode obj = (ObjectNode)tree;
        HttpHeadersBuilder builder = this.newBuilder();
        Iterator<Map.Entry<String, JsonNode>> i = obj.fields();
        while (i.hasNext()) {
            Map.Entry<String, JsonNode> e = i.next();
            AsciiString name = HttpHeaderNames.of(e.getKey());
            JsonNode values = e.getValue();
            if (!values.isArray()) {
                this.addHeader(ctx, builder, name, values);
                continue;
            }
            int numValues = values.size();
            for (int j = 0; j < numValues; ++j) {
                JsonNode v = values.get(j);
                this.addHeader(ctx, builder, name, v);
            }
        }
        try {
            HttpHeaders headers = builder.build();
            return (T)headers;
        }
        catch (IllegalStateException e) {
            return (T)((HttpHeaders)ctx.reportInputMismatch(this.handledType(), MoreObjects.firstNonNull(e.getMessage(), "Required headers are missing."), new Object[0]));
        }
    }

    private void addHeader(DeserializationContext ctx, HttpHeadersBuilder builder, AsciiString name, JsonNode valueNode) throws JsonMappingException {
        if (valueNode.isTextual()) {
            builder.add((CharSequence)name, valueNode.asText());
        } else {
            ctx.reportInputMismatch(this.handledType(), "HTTP header '%s' contains %s (%s); only strings are allowed.", new Object[]{name, valueNode.getNodeType(), valueNode});
        }
    }

    abstract HttpHeadersBuilder newBuilder();
}

