/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.rfc8032;

import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.Xof;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.digests.SHAKEDigest;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.rfc7748.X448;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.rfc7748.X448Field;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.raw.Nat;

public abstract class Ed448 {
    private static final byte[] DOM4_PREFIX = new byte[]{83, 105, 103, 69, 100, 52, 52, 56};
    private static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] L = new int[]{-1420278541, 595116690, -1916432555, 560775794, -1361693040, -1001465015, 2093622249, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int[] B_x = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] B_y = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static final Object precompLock = new Object();
    private static PointExt[] precompBaseTable = null;
    private static int[] precompBase = null;

    private static int checkPoint(int[] nArray, int[] nArray2) {
        int[] nArray3 = F.create();
        int[] nArray4 = F.create();
        int[] nArray5 = F.create();
        F.sqr(nArray, nArray4);
        F.sqr(nArray2, nArray5);
        F.mul(nArray4, nArray5, nArray3);
        F.add(nArray4, nArray5, nArray4);
        F.mul(nArray3, 39081, nArray3);
        F.subOne(nArray3);
        F.add(nArray3, nArray4, nArray3);
        F.normalize(nArray3);
        return F.isZero(nArray3);
    }

    private static int checkPoint(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = F.create();
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = F.create();
        F.sqr(nArray, nArray5);
        F.sqr(nArray2, nArray6);
        F.sqr(nArray3, nArray7);
        F.mul(nArray5, nArray6, nArray4);
        F.add(nArray5, nArray6, nArray5);
        F.mul(nArray5, nArray7, nArray5);
        F.sqr(nArray7, nArray7);
        F.mul(nArray4, 39081, nArray4);
        F.sub(nArray4, nArray7, nArray4);
        F.add(nArray4, nArray5, nArray4);
        F.normalize(nArray4);
        return F.isZero(nArray4);
    }

    private static Xof createXof() {
        return new SHAKEDigest(256);
    }

    private static int decode32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n2 |= (byArray[++n] & 0xFF) << 8;
        n2 |= (byArray[++n] & 0xFF) << 16;
        return n2 |= byArray[++n] << 24;
    }

    private static void decode32(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = Ed448.decode32(byArray, n + i * 4);
        }
    }

    private static void decodeScalar(byte[] byArray, int n, int[] nArray) {
        Ed448.decode32(byArray, n, nArray, 0, 14);
    }

    private static int encodePoint(PointExt pointExt, byte[] byArray, int n) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        F.inv(pointExt.z, nArray2);
        F.mul(pointExt.x, nArray2, nArray);
        F.mul(pointExt.y, nArray2, nArray2);
        F.normalize(nArray);
        F.normalize(nArray2);
        int n2 = Ed448.checkPoint(nArray, nArray2);
        F.encode(nArray2, byArray, n);
        byArray[n + 57 - 1] = (byte)((nArray[0] & 1) << 7);
        return n2;
    }

    public static void generatePublicKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        Xof xof = Ed448.createXof();
        byte[] byArray3 = new byte[114];
        xof.update(byArray, n, 57);
        xof.doFinal(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[57];
        Ed448.pruneScalar(byArray3, 0, byArray4);
        Ed448.scalarMultBaseEncoded(byArray4, byArray2, n2);
    }

    private static void pointAddVar(boolean bl, PointExt pointExt, PointExt pointExt2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = F.create();
        int[] nArray8 = F.create();
        int[] nArray9 = F.create();
        int[] nArray10 = F.create();
        int[] nArray11 = F.create();
        int[] nArray12 = F.create();
        if (bl) {
            nArray4 = nArray9;
            nArray3 = nArray6;
            nArray2 = nArray11;
            nArray = nArray10;
            F.sub(pointExt.y, pointExt.x, nArray12);
        } else {
            nArray4 = nArray6;
            nArray3 = nArray9;
            nArray2 = nArray10;
            nArray = nArray11;
            F.add(pointExt.y, pointExt.x, nArray12);
        }
        F.mul(pointExt.z, pointExt2.z, nArray5);
        F.sqr(nArray5, nArray6);
        F.mul(pointExt.x, pointExt2.x, nArray7);
        F.mul(pointExt.y, pointExt2.y, nArray8);
        F.mul(nArray7, nArray8, nArray9);
        F.mul(nArray9, 39081, nArray9);
        F.add(nArray6, nArray9, nArray2);
        F.sub(nArray6, nArray9, nArray);
        F.add(pointExt2.x, pointExt2.y, nArray9);
        F.mul(nArray12, nArray9, nArray12);
        F.add(nArray8, nArray7, nArray4);
        F.sub(nArray8, nArray7, nArray3);
        F.carry(nArray4);
        F.sub(nArray12, nArray6, nArray12);
        F.mul(nArray12, nArray5, nArray12);
        F.mul(nArray9, nArray5, nArray9);
        F.mul(nArray10, nArray12, pointExt2.x);
        F.mul(nArray9, nArray11, pointExt2.y);
        F.mul(nArray10, nArray11, pointExt2.z);
    }

    private static void pointAddPrecomp(PointPrecomp pointPrecomp, PointExt pointExt) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        int[] nArray3 = F.create();
        int[] nArray4 = F.create();
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = F.create();
        F.sqr(pointExt.z, nArray);
        F.mul(pointPrecomp.x, pointExt.x, nArray2);
        F.mul(pointPrecomp.y, pointExt.y, nArray3);
        F.mul(nArray2, nArray3, nArray4);
        F.mul(nArray4, 39081, nArray4);
        F.add(nArray, nArray4, nArray5);
        F.sub(nArray, nArray4, nArray6);
        F.add(pointPrecomp.x, pointPrecomp.y, nArray);
        F.add(pointExt.x, pointExt.y, nArray4);
        F.mul(nArray, nArray4, nArray7);
        F.add(nArray3, nArray2, nArray);
        F.sub(nArray3, nArray2, nArray4);
        F.carry(nArray);
        F.sub(nArray7, nArray, nArray7);
        F.mul(nArray7, pointExt.z, nArray7);
        F.mul(nArray4, pointExt.z, nArray4);
        F.mul(nArray5, nArray7, pointExt.x);
        F.mul(nArray4, nArray6, pointExt.y);
        F.mul(nArray5, nArray6, pointExt.z);
    }

    private static PointExt pointCopy(PointExt pointExt) {
        PointExt pointExt2 = new PointExt();
        Ed448.pointCopy(pointExt, pointExt2);
        return pointExt2;
    }

    private static void pointCopy(PointExt pointExt, PointExt pointExt2) {
        F.copy(pointExt.x, 0, pointExt2.x, 0);
        F.copy(pointExt.y, 0, pointExt2.y, 0);
        F.copy(pointExt.z, 0, pointExt2.z, 0);
    }

    private static void pointDouble(PointExt pointExt) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        int[] nArray3 = F.create();
        int[] nArray4 = F.create();
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        F.add(pointExt.x, pointExt.y, nArray);
        F.sqr(nArray, nArray);
        F.sqr(pointExt.x, nArray2);
        F.sqr(pointExt.y, nArray3);
        F.add(nArray2, nArray3, nArray4);
        F.carry(nArray4);
        F.sqr(pointExt.z, nArray5);
        F.add(nArray5, nArray5, nArray5);
        F.carry(nArray5);
        F.sub(nArray4, nArray5, nArray6);
        F.sub(nArray, nArray4, nArray);
        F.sub(nArray2, nArray3, nArray2);
        F.mul(nArray, nArray6, pointExt.x);
        F.mul(nArray4, nArray2, pointExt.y);
        F.mul(nArray4, nArray6, pointExt.z);
    }

    private static void pointExtendXY(PointExt pointExt) {
        F.one(pointExt.z);
    }

    private static void pointLookup(int n, int n2, PointPrecomp pointPrecomp) {
        int n3 = n * 16 * 2 * 16;
        for (int i = 0; i < 16; ++i) {
            int n4 = (i ^ n2) - 1 >> 31;
            F.cmov(n4, precompBase, n3, pointPrecomp.x, 0);
            F.cmov(n4, precompBase, n3 += 16, pointPrecomp.y, 0);
            n3 += 16;
        }
    }

    private static PointExt[] pointPrecomputeVar(PointExt pointExt, int n) {
        PointExt pointExt2 = Ed448.pointCopy(pointExt);
        Ed448.pointDouble(pointExt2);
        PointExt[] pointExtArray = new PointExt[n];
        pointExtArray[0] = Ed448.pointCopy(pointExt);
        for (int i = 1; i < n; ++i) {
            pointExtArray[i] = Ed448.pointCopy(pointExtArray[i - 1]);
            Ed448.pointAddVar(false, pointExt2, pointExtArray[i]);
        }
        return pointExtArray;
    }

    private static void pointSetNeutral(PointExt pointExt) {
        F.zero(pointExt.x);
        F.one(pointExt.y);
        F.one(pointExt.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = precompLock;
        synchronized (object) {
            if (precompBase != null) {
                return;
            }
            PointExt pointExt = new PointExt();
            F.copy(B_x, 0, pointExt.x, 0);
            F.copy(B_y, 0, pointExt.y, 0);
            Ed448.pointExtendXY(pointExt);
            precompBaseTable = Ed448.pointPrecomputeVar(pointExt, 32);
            precompBase = F.createTable(160);
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                int n2;
                int n3;
                int n4;
                PointExt[] pointExtArray = new PointExt[5];
                PointExt pointExt2 = new PointExt();
                Ed448.pointSetNeutral(pointExt2);
                for (int j = 0; j < 5; ++j) {
                    Ed448.pointAddVar(true, pointExt, pointExt2);
                    Ed448.pointDouble(pointExt);
                    pointExtArray[j] = Ed448.pointCopy(pointExt);
                    if (i + j == 8) continue;
                    for (n4 = 1; n4 < 18; ++n4) {
                        Ed448.pointDouble(pointExt);
                    }
                }
                PointExt[] pointExtArray2 = new PointExt[16];
                n4 = 0;
                pointExtArray2[n4++] = pointExt2;
                for (int j = 0; j < 4; ++j) {
                    n3 = 1 << j;
                    n2 = 0;
                    while (n2 < n3) {
                        pointExtArray2[n4] = Ed448.pointCopy(pointExtArray2[n4 - n3]);
                        Ed448.pointAddVar(false, pointExtArray[j], pointExtArray2[n4]);
                        ++n2;
                        ++n4;
                    }
                }
                int[] nArray = F.createTable(16);
                int[] nArray2 = F.create();
                F.copy(pointExtArray2[0].z, 0, nArray2, 0);
                F.copy(nArray2, 0, nArray, 0);
                n2 = 0;
                while (++n2 < 16) {
                    F.mul(nArray2, pointExtArray2[n2].z, nArray2);
                    F.copy(nArray2, 0, nArray, n2 * 16);
                }
                F.invVar(nArray2, nArray2);
                --n2;
                int[] nArray3 = F.create();
                while (n2 > 0) {
                    int n5 = n2--;
                    F.copy(nArray, n2 * 16, nArray3, 0);
                    F.mul(nArray3, nArray2, nArray3);
                    F.copy(nArray3, 0, nArray, n5 * 16);
                    F.mul(nArray2, pointExtArray2[n5].z, nArray2);
                }
                F.copy(nArray2, 0, nArray, 0);
                for (n3 = 0; n3 < 16; ++n3) {
                    PointExt pointExt3 = pointExtArray2[n3];
                    F.copy(nArray, n3 * 16, pointExt3.z, 0);
                    F.mul(pointExt3.x, pointExt3.z, pointExt3.x);
                    F.mul(pointExt3.y, pointExt3.z, pointExt3.y);
                    F.copy(pointExt3.x, 0, precompBase, n);
                    F.copy(pointExt3.y, 0, precompBase, n += 16);
                    n += 16;
                }
            }
        }
    }

    private static void pruneScalar(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray, n, byArray2, 0, 56);
        byArray2[0] = (byte)(byArray2[0] & 0xFC);
        byArray2[55] = (byte)(byArray2[55] | 0x80);
        byArray2[56] = 0;
    }

    private static void scalarMultBase(byte[] byArray, PointExt pointExt) {
        Ed448.precompute();
        int[] nArray = new int[15];
        Ed448.decodeScalar(byArray, 0, nArray);
        nArray[14] = 4 + Nat.cadd(14, ~nArray[0] & 1, nArray, L, nArray);
        Nat.shiftDownBit(nArray.length, nArray, 0);
        PointPrecomp pointPrecomp = new PointPrecomp();
        Ed448.pointSetNeutral(pointExt);
        int n = 17;
        while (true) {
            int n2 = n;
            for (int i = 0; i < 5; ++i) {
                int n3;
                int n4;
                int n5 = 0;
                for (n4 = 0; n4 < 5; ++n4) {
                    n3 = nArray[n2 >>> 5] >>> (n2 & 0x1F);
                    n5 &= ~(1 << n4);
                    n5 ^= n3 << n4;
                    n2 += 18;
                }
                n4 = n5 >>> 4 & 1;
                n3 = (n5 ^ -n4) & 0xF;
                Ed448.pointLookup(i, n3, pointPrecomp);
                F.cnegate(n4, pointPrecomp.x);
                Ed448.pointAddPrecomp(pointPrecomp, pointExt);
            }
            if (--n < 0) break;
            Ed448.pointDouble(pointExt);
        }
    }

    private static void scalarMultBaseEncoded(byte[] byArray, byte[] byArray2, int n) {
        PointExt pointExt = new PointExt();
        Ed448.scalarMultBase(byArray, pointExt);
        if (0 == Ed448.encodePoint(pointExt, byArray2, n)) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseXY(X448.Friend friend, byte[] byArray, int n, int[] nArray, int[] nArray2) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X448");
        }
        byte[] byArray2 = new byte[57];
        Ed448.pruneScalar(byArray, n, byArray2);
        PointExt pointExt = new PointExt();
        Ed448.scalarMultBase(byArray2, pointExt);
        if (0 == Ed448.checkPoint(pointExt.x, pointExt.y, pointExt.z)) {
            throw new IllegalStateException();
        }
        F.copy(pointExt.x, 0, nArray, 0);
        F.copy(pointExt.y, 0, nArray2, 0);
    }

    private static class F
    extends X448Field {
    }

    private static class PointExt {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();

        private PointExt() {
        }
    }

    private static class PointPrecomp {
        int[] x = F.create();
        int[] y = F.create();

        private PointPrecomp() {
        }
    }
}

