/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ArmeriaHttpHeadersFactory;
import com.linecorp.armeria.server.NettyHttp1Headers;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;
import java.util.Objects;

final class NettyHttp1Request
extends DefaultHttpMessage
implements HttpRequest {
    private HttpMethod method;
    private String uri;

    NettyHttp1Request(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion, ArmeriaHttpHeadersFactory.INSTANCE);
        this.method = Preconditions.checkNotNull(method, "method");
        this.uri = Preconditions.checkNotNull(uri, "uri");
        this.headers().delegate().method(MoreObjects.firstNonNull(com.linecorp.armeria.common.HttpMethod.tryParse(method.name()), com.linecorp.armeria.common.HttpMethod.UNKNOWN));
        this.headers().delegate().path(uri);
    }

    @Override
    @Deprecated
    public HttpMethod getMethod() {
        return this.method();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    @Deprecated
    public String getUri() {
        return this.uri();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpRequest setMethod(HttpMethod method) {
        this.method = ObjectUtil.checkNotNull(method, "method");
        this.headers().delegate().method(MoreObjects.firstNonNull(com.linecorp.armeria.common.HttpMethod.tryParse(method.name()), com.linecorp.armeria.common.HttpMethod.UNKNOWN));
        return this;
    }

    @Override
    public HttpRequest setUri(String uri) {
        this.uri = ObjectUtil.checkNotNull(uri, "uri");
        this.headers().delegate().path(uri);
        return this;
    }

    @Override
    public HttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public NettyHttp1Headers headers() {
        return (NettyHttp1Headers)super.headers();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.headers().delegate().hashCode(), super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NettyHttp1Request)) {
            return false;
        }
        NettyHttp1Request other = (NettyHttp1Request)o;
        return this.headers().delegate().equals(other.headers().delegate()) && super.equals(o);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("decoderResult", this.decoderResult()).add("version", this.protocolVersion()).add("method", this.method()).add("headers", this.headers()).toString();
    }
}

