/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.throttling;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.throttling.AbstractThrottlingServiceBuilder;
import com.linecorp.armeria.server.throttling.ThrottlingAcceptHandler;
import com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import com.linecorp.armeria.server.throttling.ThrottlingService;
import com.linecorp.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.function.Function;

public final class ThrottlingServiceBuilder
extends AbstractThrottlingServiceBuilder<HttpRequest, HttpResponse> {
    private static final ThrottlingRejectHandler<HttpRequest, HttpResponse> DEFAULT_REJECT_HANDLER = (delegate, ctx, req, cause) -> HttpResponse.of(HttpStatus.TOO_MANY_REQUESTS);

    ThrottlingServiceBuilder(ThrottlingStrategy<HttpRequest> strategy) {
        super(strategy, DEFAULT_REJECT_HANDLER);
    }

    public ThrottlingServiceBuilder onAcceptedRequest(ThrottlingAcceptHandler<HttpRequest, HttpResponse> acceptHandler) {
        this.setAcceptHandler(acceptHandler);
        return this;
    }

    public ThrottlingServiceBuilder onRejectedRequest(ThrottlingRejectHandler<HttpRequest, HttpResponse> rejectHandler) {
        this.setRejectHandler(rejectHandler);
        return this;
    }

    public ThrottlingService build(HttpService delegate) {
        return new ThrottlingService(Objects.requireNonNull(delegate, "delegate"), this.getStrategy(), this.getAcceptHandler(), this.getRejectHandler());
    }

    public Function<? super HttpService, ThrottlingService> newDecorator() {
        ThrottlingStrategy strategy = this.getStrategy();
        ThrottlingAcceptHandler acceptHandler = this.getAcceptHandler();
        ThrottlingRejectHandler rejectHandler = this.getRejectHandler();
        return service -> new ThrottlingService((HttpService)service, strategy, acceptHandler, rejectHandler);
    }
}

