/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.AsyncProfilerQueryService;
import org.apache.skywalking.oap.server.core.query.input.AsyncProfilerAnalyzatonRequest;
import org.apache.skywalking.oap.server.core.query.input.AsyncProfilerTaskListRequest;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerStackTree;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskListResult;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskLogOperationType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskProgress;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProfilerQuery
implements GraphQLQueryResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncProfilerQuery.class);
    private final ModuleManager moduleManager;
    private AsyncProfilerQueryService queryService;

    public AsyncProfilerQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private AsyncProfilerQueryService getAsyncProfilerQueryService() {
        if (this.queryService == null) {
            this.queryService = (AsyncProfilerQueryService)this.moduleManager.find("core").provider().getService(AsyncProfilerQueryService.class);
        }
        return this.queryService;
    }

    public AsyncProfilerTaskListResult queryAsyncProfilerTaskList(AsyncProfilerTaskListRequest request) throws IOException {
        List tasks = this.getAsyncProfilerQueryService().queryTask(request.getServiceId(), request.getQueryDuration(), request.getLimit());
        return new AsyncProfilerTaskListResult(null, tasks);
    }

    public AsyncProfilerAnalyzation queryAsyncProfilerAnalyze(AsyncProfilerAnalyzatonRequest request) throws IOException {
        AsyncProfilerStackTree eventFrameTrees = this.getAsyncProfilerQueryService().queryJFRData(request.getTaskId(), request.getInstanceIds(), request.getEventType());
        return new AsyncProfilerAnalyzation(eventFrameTrees);
    }

    public AsyncProfilerTaskProgress queryAsyncProfilerTaskProgress(String taskId) throws IOException {
        AsyncProfilerTaskProgress asyncProfilerTaskProgress = new AsyncProfilerTaskProgress();
        List logs = this.getAsyncProfilerQueryService().queryAsyncProfilerTaskLogs(taskId);
        asyncProfilerTaskProgress.setLogs(logs);
        ArrayList errorInstances = new ArrayList();
        ArrayList successInstances = new ArrayList();
        logs.forEach(log -> {
            if (AsyncProfilerTaskLogOperationType.EXECUTION_FINISHED.equals((Object)log.getOperationType())) {
                successInstances.add(log.getInstanceId());
            } else if (AsyncProfilerTaskLogOperationType.EXECUTION_TASK_ERROR.equals((Object)log.getOperationType()) || AsyncProfilerTaskLogOperationType.JFR_UPLOAD_FILE_TOO_LARGE_ERROR.equals((Object)log.getOperationType())) {
                errorInstances.add(log.getInstanceId());
            }
        });
        asyncProfilerTaskProgress.setErrorInstanceIds(errorInstances);
        asyncProfilerTaskProgress.setSuccessInstanceIds(successInstances);
        return asyncProfilerTaskProgress;
    }
}

