/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkPath {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkPath.class);
    private static File PATH;

    public static File getPath() {
        if (PATH == null) {
            PATH = WorkPath.findPath();
        }
        return PATH;
    }

    private static File findPath() {
        String classResourcePath = WorkPath.class.getName().replaceAll("\\.", "/") + ".class";
        URL resource = ClassLoader.getSystemClassLoader().getResource(classResourcePath);
        if (resource != null) {
            boolean isInJar;
            String urlString = resource.toString();
            LOGGER.debug("The beacon class location is {}.", (Object)urlString);
            int insidePathIndex = urlString.indexOf(33);
            boolean bl = isInJar = insidePathIndex > -1;
            if (isInJar) {
                urlString = urlString.substring(urlString.indexOf("file:"), insidePathIndex);
                File agentJarFile = null;
                try {
                    agentJarFile = new File(new URL(urlString).toURI());
                }
                catch (MalformedURLException e) {
                    throw new UnexpectedException("Can not locate oap core jar file by url:" + urlString, e);
                }
                catch (URISyntaxException e) {
                    throw new UnexpectedException("Can not locate oap core jar file by url:" + urlString, e);
                }
                if (agentJarFile.exists()) {
                    return agentJarFile.getParentFile();
                }
            } else {
                int prefixLength = "file:".length();
                String classLocation = urlString.substring(prefixLength, urlString.length() - classResourcePath.length());
                return new File(classLocation);
            }
        }
        throw new UnexpectedException("Can not locate oap core jar file by path:" + classResourcePath);
    }
}

